/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar;

import com.bsiag.scout.rt.ui.swing.rayo.window.desktop.toolbar.RayoNavigationWidgetButton;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;

public class RayoStopRefreshButton
extends RayoNavigationWidgetButton {
    private P_GlowThread m_glowThread;
    private Object m_glowThreadLock = new Object();
    private static final int FPS = 20;
    private static final int MS_PER_FRAME = 50;
    private static final Point GLOW_POSITION = new Point(73, 6);
    private boolean m_loading = false;
    private volatile boolean m_showGlow = false;
    private IconGroup m_stopIconGroup;
    private Icon[] m_glowFrames;
    private int m_glowFrame = 0;
    private int m_glowDir = 1;

    public RayoStopRefreshButton(JComponent parent) {
        super(RayoNavigationWidgetButton.ButtonName.STOP_REFRESH, parent);
    }

    void loadGlowAnimation(String iconUrl) {
        this.m_glowFrames = new Icon[10];
        int i = 0;
        while (i < 10) {
            String frameUrl = String.valueOf(iconUrl) + "_" + i;
            this.m_glowFrames[i] = Activator.getIcon((String)frameUrl);
            ++i;
        }
    }

    public void showRefreshIcon() {
        this.setActiveActionType(RayoNavigationWidgetButton.ActionType.PrimaryAction);
        this.repaintParent();
    }

    public void showStopIcon() {
        this.setActiveActionType(RayoNavigationWidgetButton.ActionType.SecondaryAction);
        this.repaintParent();
    }

    public boolean isLoading() {
        return this.m_loading;
    }

    public void setLoading(boolean loading) {
        this.m_loading = loading;
        if (loading) {
            this.startGlow();
            this.showStopIcon();
        } else {
            this.showRefreshIcon();
            this.killGlow();
        }
    }

    private void startGlow() {
        this.m_showGlow = true;
        this.m_glowFrame = 0;
        this.m_glowDir = 1;
        this.m_glowThread = new P_GlowThread();
        this.m_glowThread.start();
    }

    private void killGlow() {
        P_GlowThread t = this.m_glowThread;
        if (t != null) {
            t.interrupt();
        }
    }

    public void setStopIconId(String iconId) {
        this.m_stopIconGroup = new IconGroup(iconId);
    }

    @Override
    protected void paintButton(Component c, Graphics g) {
        this.paintGlow(c, g);
        super.paintButton(c, g);
    }

    private void paintGlow(Component c, Graphics g) {
        if (this.m_showGlow) {
            this.paintPressedImage(this.m_glowFrames[this.m_glowFrame], GLOW_POSITION, this.isPressed(), c, g);
        }
    }

    @Override
    public void buttonClicked(int button) {
        this.performAction(this.getActiveAction());
    }

    class P_GlowThread
    extends Thread {
        P_GlowThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RayoStopRefreshButton.this.m_glowThreadLock;
            synchronized (object) {
                boolean interrupted = false;
                while (this == RayoStopRefreshButton.this.m_glowThread) {
                    RayoStopRefreshButton rayoStopRefreshButton = RayoStopRefreshButton.this;
                    rayoStopRefreshButton.m_glowFrame = rayoStopRefreshButton.m_glowFrame + RayoStopRefreshButton.this.m_glowDir;
                    if (RayoStopRefreshButton.this.m_glowFrame == 0 || RayoStopRefreshButton.this.m_glowFrame == RayoStopRefreshButton.this.m_glowFrames.length - 1) {
                        RayoStopRefreshButton rayoStopRefreshButton2 = RayoStopRefreshButton.this;
                        rayoStopRefreshButton2.m_glowDir = rayoStopRefreshButton2.m_glowDir * -1;
                    }
                    if (interrupted && RayoStopRefreshButton.this.m_glowFrame == 0) {
                        RayoStopRefreshButton.this.m_showGlow = false;
                        RayoStopRefreshButton.this.m_glowThread = null;
                        return;
                    }
                    try {
                        Thread.sleep(50 + this.getSineDelayForCurrentFrame());
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    RayoStopRefreshButton.this.repaintParent();
                }
            }
        }

        private int getSineDelayForCurrentFrame() {
            float degreeForFrame = 90 / (RayoStopRefreshButton.this.m_glowFrames.length - 1) * RayoStopRefreshButton.this.m_glowFrame;
            int delayPerFrame = (int)(Math.sin(this.toRadian(degreeForFrame)) * 50.0 * 2.0);
            return delayPerFrame;
        }

        private float toRadian(float degree) {
            return (float)((double)degree * (Math.PI / 180));
        }
    }
}

