/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo;

import com.bsiag.javax.swing.plaf.synth.SynthLookAndFeel;
import java.io.InputStream;
import java.text.ParseException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ILookAndFeelConfigurator;
import org.eclipse.scout.rt.ui.swing.ILookAndFeelProvider;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class Rayo
implements ILookAndFeelProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(Rayo.class);
    private static final String EXTENSION_POINT_PLUGIN_ID = "org.eclipse.scout.rt.ui.swing";
    private static final String EXTENSION_POINT_ID = "lafconfigurator";

    public void installLookAndFeel() {
        SynthLookAndFeel synthLaf = new SynthLookAndFeel();
        try {
            ILookAndFeelConfigurator configurator = this.readExtensionPoint();
            configurator.configure();
            synthLaf.load(configurator.getConfigurationFile(), Rayo.class);
            UIManager.setLookAndFeel(synthLaf);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
    }

    private ILookAndFeelConfigurator readExtensionPoint() {
        IExtensionPoint ext = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_PLUGIN_ID, EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ILookAndFeelConfigurator configurator = (ILookAndFeelConfigurator)element.createExecutableExtension("class");
                LOG.info("using contributed laf configurator class " + configurator.getClass().getCanonicalName() + " " + configurator.toString());
                return configurator;
            }
            catch (CoreException e) {
                LOG.error("failed to create instance of ILookAndFeelConfigurator", (Throwable)e);
                ++n2;
            }
        }
        LOG.info("using default Rayo configurator");
        return new DefaultRayoConfigurator();
    }

    private static class DefaultRayoConfigurator
    implements ILookAndFeelConfigurator {
        private boolean useLafFrameAndDialog = SwingUtility.hasScoutLookAndFeelFrameAndDialog();

        private DefaultRayoConfigurator() {
        }

        public void configure() {
            JFrame.setDefaultLookAndFeelDecorated(this.useLafFrameAndDialog);
            JDialog.setDefaultLookAndFeelDecorated(this.useLafFrameAndDialog);
            System.setProperty("awt.useSystemAAFontSettings", "off");
            System.setProperty("swing.aatext", "false");
        }

        public InputStream getConfigurationFile() {
            String rayoXmlFile = this.useLafFrameAndDialog ? "rayoFrameAndDialog.xml" : "rayo.xml";
            return this.getClass().getResourceAsStream(rayoXmlFile);
        }
    }
}

