/*
 * Copyright (c) 2011, BSI Business Systems Integration AG. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. BSI Business Systems Integration AG
 * designates this particular file as subject to the "Classpath" exception as provided
 * by BSI Business Systems Integration AG in the LICENSE_BSI file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact BSI Business Systems Integration AG, Taefernstrasse 16a,
 * CH-5405 Baden, Switzerland or visit www.bsiag.com if you need additional
 * information or have any questions.
 */
package com.bsiag.scout.rt.ui.swing.laf.rayo.tests;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneConstants;

import com.bsiag.scout.rt.ui.swing.laf.rayo.Rayo;

public class TestSmartfieldPopupAndTable {
  public static void main(String[] args) {
    new Rayo().installLookAndFeel();

    JFrame frame = new JFrame("TestPopupAndTable");

    String[] columnNames = {"First Name",
        "Last Name",
        "Sport",
        "# of Years"};

    Object[][] data = {
        {"Mary", "Campione",
            "Snowboarding", new Integer(5)},
        {"Alison", "Huml",
            "Rowing", new Integer(3)},
        {"Kathy", "Walrath",
            "Knitting", new Integer(2)},
        {"Sharon", "Zakhour",
            "Speed reading", new Integer(20)},
        {"Philip", "Milne",
            "Pool", new Integer(10)}
    };

    // table
    JTable table = new JTable(data, columnNames);
    table.setName("Synth.SmartfieldTable");
    table.setIntercellSpacing(new Dimension(0, 1));
    table.setShowHorizontalLines(true);
    table.setShowVerticalLines(false);
    table.setTableHeader(null);
    table.getColumnModel().setColumnMargin(0);

    // scroll pane
    JScrollPane scrollPane = new JScrollPane(table);
    scrollPane.setOpaque(false);
    scrollPane.getViewport().setOpaque(false);
    scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

    frame.getRootPane().setName("Synth.Popup");
    frame.getContentPane().setLayout(new BorderLayout(0, 0));
    frame.getContentPane().add(scrollPane, BorderLayout.CENTER);

    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setSize(400, 400);
    frame.setVisible(true);
  }
}
