/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.log4j;

import org.eclipse.scout.commons.logger.IScoutLogger;

/**
 * <p>
 * This class is a minimal implementation of the original <code>org.apache.log4j.Logger</code> class (as found in log4j
 * 1.2) delegating all calls to a {@link java.util.logging.Logger} instance.
 * </p>
 *
 * @author Ceki G&uuml;lc&uuml;
 */
@SuppressWarnings("rawtypes")
public class Logger extends Category {

  Logger(String name) {
    super(name);
  }

  public static Logger getLogger(String name) {
    return Log4jLoggerFactory.getLogger(name);
  }

  public static Logger getLogger(Class clazz) {
    return getLogger(clazz.getName());
  }

  public static Logger getRootLogger() {
    return Log4jLoggerFactory.getLogger("");
  }

  /**
   * Delegates to JUL.
   */
  public boolean isTraceEnabled() {
    return logger.isTraceEnabled();
  }

  /**
   * Delegates to JUL.
   */
  public void trace(Object message) {
    log(IScoutLogger.LEVEL_TRACE, convertToString(message), null);
  }

  /**
   * Delegates to JUL.
   */
  public void trace(Object message, Throwable t) {
	  log(IScoutLogger.LEVEL_TRACE, convertToString(message), t);
  }
}
