/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.server.jdbc.style;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.style.AbstractSqlStyle;

public class PostgreSqlStyle
extends AbstractSqlStyle {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PostgreSqlStyle.class);

    public void testConnection(Connection conn) throws SQLException {
        Statement testStatement = null;
        try {
            testStatement = conn.createStatement();
            testStatement.execute("SELECT 1 + 1");
        }
        finally {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close the connection", (Throwable)e);
                }
            }
        }
    }

    public Object readBind(ResultSet rs, ResultSetMetaData meta, int type, int jdbcBindIndex) throws SQLException {
        Object result = null;
        if (-7 == type && (result = rs.getObject(jdbcBindIndex)) instanceof Boolean) {
            return result;
        }
        return super.readBind(rs, meta, type, jdbcBindIndex);
    }

    public boolean isBlobEnabled() {
        return false;
    }

    public boolean isClobEnabled() {
        return false;
    }

    public boolean isLargeString(String s) {
        return s.length() > 4000;
    }

    protected int getMaxListSize() {
        return 1000;
    }
}

