/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.server.jdbc.style;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.style.AbstractSqlStyle;

public class MySqlSqlStyle
extends AbstractSqlStyle {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MySqlSqlStyle.class);
    private static final String DATE_SQL_METHOD = "DATE(";
    private static final String UPPERCASE_SQL_METHOD = "upper(";
    private static final String CONCATENATE_SQL_METHOD = "concat(";
    private static final String SQL_ANY = "'%'";

    public void testConnection(Connection conn) throws SQLException {
        Statement testStatement = null;
        try {
            testStatement = conn.createStatement();
            testStatement.execute("SELECT 1 FROM DUAL");
        }
        finally {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close the connection", (Throwable)e);
                }
            }
        }
    }

    public boolean isBlobEnabled() {
        return false;
    }

    public boolean isClobEnabled() {
        return false;
    }

    public boolean isLargeString(String s) {
        return s.length() > 4000;
    }

    protected int getMaxListSize() {
        return 1000;
    }

    public String getNvlToken() {
        return "IFNULL";
    }

    public String createDateGE(String attribute, String bindName) {
        return String.valueOf(attribute) + ">=" + DATE_SQL_METHOD + this.adaptBindName(bindName) + ")";
    }

    public String createDateGT(String attribute, String bindName) {
        return String.valueOf(attribute) + ">" + DATE_SQL_METHOD + this.adaptBindName(bindName) + ")";
    }

    public String createDateLE(String attribute, String bindName) {
        return String.valueOf(attribute) + "<" + DATE_SQL_METHOD + this.adaptBindName(bindName) + ") + INTERVAL 1 DAY";
    }

    public String createDateLT(String attribute, String bindName) {
        return String.valueOf(attribute) + "<" + DATE_SQL_METHOD + this.adaptBindName(bindName) + ")";
    }

    public String createStartsWith(String attribute, String bindName) {
        return UPPERCASE_SQL_METHOD + attribute + ") like " + UPPERCASE_SQL_METHOD + CONCATENATE_SQL_METHOD + this.adaptBindName(bindName) + "," + SQL_ANY + "))";
    }

    public String createNotStartsWith(String attribute, String bindName) {
        return UPPERCASE_SQL_METHOD + attribute + ") not like " + UPPERCASE_SQL_METHOD + CONCATENATE_SQL_METHOD + this.adaptBindName(bindName) + "," + SQL_ANY + "))";
    }

    public String createEndsWith(String attribute, String bindName) {
        return UPPERCASE_SQL_METHOD + attribute + ") like " + UPPERCASE_SQL_METHOD + CONCATENATE_SQL_METHOD + SQL_ANY + "," + this.adaptBindName(bindName) + "))";
    }

    public String createNotEndsWith(String attribute, String bindName) {
        return UPPERCASE_SQL_METHOD + attribute + ") not like " + UPPERCASE_SQL_METHOD + CONCATENATE_SQL_METHOD + SQL_ANY + "," + this.adaptBindName(bindName) + "))";
    }

    public String createContains(String attribute, String bindName) {
        return UPPERCASE_SQL_METHOD + attribute + ") like " + UPPERCASE_SQL_METHOD + CONCATENATE_SQL_METHOD + SQL_ANY + "," + this.adaptBindName(bindName) + "," + SQL_ANY + "))";
    }

    public String createNotContains(String attribute, String bindName) {
        return UPPERCASE_SQL_METHOD + attribute + ") not like " + UPPERCASE_SQL_METHOD + CONCATENATE_SQL_METHOD + SQL_ANY + "," + this.adaptBindName(bindName) + "," + SQL_ANY + "))";
    }
}

