/*
 * Decompiled with CFR 0.152.
 */
package com.bsiag.scout.rt.server.jdbc.style;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.style.AbstractSqlStyle;

public class OracleSqlStyle
extends AbstractSqlStyle {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(OracleSqlStyle.class);

    public String getConcatOp() {
        return "||";
    }

    public String getLikeWildcard() {
        return "%";
    }

    protected int getMaxListSize() {
        return 1000;
    }

    public boolean isLargeString(String s) {
        return s.length() > 4000;
    }

    public boolean isBlobEnabled() {
        return true;
    }

    public boolean isClobEnabled() {
        return true;
    }

    public void testConnection(Connection conn) throws SQLException {
        Statement testStatement = null;
        try {
            testStatement = conn.createStatement();
            testStatement.execute("SELECT 1 FROM DUAL");
        }
        finally {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (Exception e) {
                    LOG.error("Failed to close the connection", (Throwable)e);
                }
            }
        }
    }

    public void writeBind(PreparedStatement ps, int jdbcBindIndex, SqlBind bind) throws SQLException {
        switch (bind.getSqlType()) {
            case 2004: {
                if (bind.getValue() instanceof Blob) {
                    ps.setBlob(jdbcBindIndex, (Blob)bind.getValue());
                    break;
                }
                byte[] data = (byte[])bind.getValue();
                if (data != null) {
                    ps.setBlob(jdbcBindIndex, new ByteArrayInputStream(data), data.length);
                    break;
                }
                ps.setNull(jdbcBindIndex, 2004);
                break;
            }
            case 2005: {
                if (bind.getValue() instanceof Clob) {
                    ps.setClob(jdbcBindIndex, (Clob)bind.getValue());
                    break;
                }
                String s = (String)bind.getValue();
                if (s != null) {
                    ps.setClob(jdbcBindIndex, new StringReader(s), s.length());
                    break;
                }
                ps.setNull(jdbcBindIndex, 2005);
                break;
            }
            default: {
                super.writeBind(ps, jdbcBindIndex, bind);
            }
        }
    }
}

