/*******************************************************************************
 * Copyright (c) 2011 BSI Business Systems Integration.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 ******************************************************************************/
package com.bsiag.scout.rt.server.jdbc;

import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

public abstract class AbstractPostgresSqlService extends AbstractSqlService {

  @ConfigProperty(ConfigProperty.SQL_STYLE)
  @Order(80)
  @ConfigPropertyValue("com.bsiag.scout.rt.server.jdbc.style.PostgresSqlStyle.class")
  @Override
  protected Class<? extends ISqlStyle> getConfiguredSqlStyle() {
    return com.bsiag.scout.rt.server.jdbc.style.PostgresSqlStyle.class;
  }

  @ConfigProperty(ConfigProperty.STRING)
  @Order(100)
  @ConfigPropertyValue("\"org.postgresql.Driver\"")
  @Override
  protected String getConfiguredJdbcDriverName() {
    return "org.postgresql.Driver";
  }

  @ConfigProperty(ConfigProperty.STRING)
  @Order(110)
  @ConfigPropertyValue("\"jdbc:postgresql://[host][:port]/[database]\"")
  @Override
  protected String getConfiguredJdbcMappingName() {
    return "jdbc:postgresql://[host][:port]/[database]";
  }
}
