/*******************************************************************************
 * Copyright (c) 2011 BSI Business Systems Integration.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 ******************************************************************************/
package com.bsiag.scout.rt.server.jdbc;

import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.server.services.common.jdbc.AbstractSqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

public abstract class AbstractOracleSqlService extends AbstractSqlService {

  @ConfigProperty(ConfigProperty.SQL_STYLE)
  @Order(80)
  @ConfigPropertyValue("com.bsiag.scout.rt.server.jdbc.style.OracleSqlStyle.class")
  @Override
  protected Class<? extends ISqlStyle> getConfiguredSqlStyle() {
    return com.bsiag.scout.rt.server.jdbc.style.OracleSqlStyle.class;
  }

  @ConfigProperty(ConfigProperty.STRING)
  @Order(100)
  @ConfigPropertyValue("\"oracle.jdbc.OracleDriver\"")
  @Override
  protected String getConfiguredJdbcDriverName() {
    return "oracle.jdbc.OracleDriver";
  }

  @ConfigProperty(ConfigProperty.STRING)
  @Order(110)
  @ConfigPropertyValue("\"jdbc:oracle:thin:@[host][:port]/[database]\"")
  @Override
  protected String getConfiguredJdbcMappingName() {
    return "jdbc:oracle:thin:@[host][:port]/[database]";
  }
}
