/*******************************************************************************
 * Copyright (c) 2013,2014 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Ivan Motsch (BSI Business Systems Integration AG) - initial API and implementation
 *     Stephan Leicht Vogt (BSI Business Systems Integration AG) - adaption to JaxWS
 ******************************************************************************/
package org.eclipse.scout.jaxws.service.internal;

import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.service.IJaxWsConnectionHandler;
import org.eclipse.scout.jaxws.service.IWebServiceClient;

/**
 * System-wide connection pool for pooling connections There is one pool for
 * every ISqlService sub class type If possible, every scout Session is provided
 * with always the same connection it had in the last request this class is
 * thread-safe
 */
public class JaxWsConnectionProvider<S extends Service, P> extends InternalJaxWsConnectionProvider<S, P> implements IJaxWsConnectionHandler<S, P> {
  private static final long serialVersionUID = 1L;
  private static final IScoutLogger LOG = ScoutLogManager.getLogger(JaxWsConnectionProvider.class);//all connection provider classes use log of JaxWsConnectionProvider

  public JaxWsConnectionProvider(IWebServiceClient<S> webServiceClient, Class<? extends P> portTypeClazz, long connectionMaxAgeMillis) {
    super(webServiceClient, portTypeClazz, connectionMaxAgeMillis);
  }

  /**
   * @returns the reference to the life stats object. The object is finally attached to this connection provider, hence
   *          it will never be dereferenced.
   */
  public IJaxWsConnectionProviderStats getStats() {
    return super.getStatsImpl();
  }

  @Override
  public P getConnection(WebServiceFeature... webServiceFeatures) {
    return (P) leaseConnection(webServiceFeatures);
  }

  @Override
  public void cancelConnection(P portType) {
    cancelOpenConnection(portType);
  }

  @Override
  public void closeConnection(P portType) {
    releaseConnection(portType);
  }

  @Override
  public void stop() {
    stopHousekeeping();
  }
}
