/*******************************************************************************
 * Copyright (c) 2014 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Ivan Motsch (BSI Business Systems Integration AG) - initial API and implementation
 *     Stephan Leicht Vogt (BSI Business Systems Integration AG) - adaption to JaxWS
 ******************************************************************************/
package org.eclipse.scout.jaxws.service.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@SuppressWarnings({"rawtypes", "unchecked"})
public abstract class AbstractInvocationHandler<T> implements InvocationHandler {
  private final T m_impl;
  private final Class[] m_types;
  private final T m_proxy;

  protected AbstractInvocationHandler(T impl, Class... types) {
    m_impl = impl;
    m_types = types;
    m_proxy = (T) Proxy.newProxyInstance(impl.getClass().getClassLoader(), m_types, this);
  }

  public T getImpl() {
    return m_impl;
  }

  public T getProxy() {
    return m_proxy;
  }

  @Override
  public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
    if ("hashCode".equals(method.getName())) {
      return m_impl.hashCode();
    }
    else if ("equals".equals(method.getName())) {
      return m_proxy == args[0];
    }
    else if ("toString".equals(method.getName())) {
      return "{proxy}" + m_impl.toString();
    }
    else if ("unwrap".equals(method.getName())) {
      if (((Class) args[0]).isAssignableFrom(m_types[0])) {
        return m_impl;
      }
      return null;
    }
    try {
      return method.invoke(m_impl, args);
    }
    catch (InvocationTargetException e) {
      throw e.getTargetException();
    }
  }
}
