/*******************************************************************************
 * Copyright (c) 2013,2014 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Ivan Motsch (BSI Business Systems Integration AG) - initial API and implementation
 *     Stephan Leicht Vogt (BSI Business Systems Integration AG) - adaption to JaxWS
 ******************************************************************************/
package org.eclipse.scout.jaxws.service;

import javax.xml.ws.Service;

import org.eclipse.scout.service.IService;

public interface IJaxWsConnectionProviderService extends IService {
  long MILLIS_PER_SECOND = 1000L;
  long SECONDS_PER_MINUTE = 60L;

  long DEFAULT_CHECK_INTERVAL = 30L;//30 seconds
  long DEFAULT_CONNECTION_MAX_AGE = 10L * SECONDS_PER_MINUTE;//10 min
  long DEFAULT_STATEMENT_BUSY_TIMEOUT = 2L * SECONDS_PER_MINUTE;//2 min

  <S extends Service, P> IJaxWsConnectionHandler<S, P> createConnectionProvider(IWebServiceClient<S> webServiceClient, Class<? extends P> portTypeClazz);
}
