/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.jaxws.service.internal;

import java.util.List;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProvider;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProviderService;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticFactory;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;

/**
 *
 */
public class JaxWsConnectionProviderDiagnostic implements IDiagnostic {

  private final JaxWsConnectionProviderService m_jaxWsConnectionProviderService;

  /**
   * @param jaxWsConnectionProviderService
   */
  public JaxWsConnectionProviderDiagnostic(JaxWsConnectionProviderService jaxWsConnectionProviderService) {
    m_jaxWsConnectionProviderService = jaxWsConnectionProviderService;
  }

  /*
   * Diagnostics
   */
  @Override
  public void addDiagnosticItemToList(List<List<String>> result) {
    try {
      DiagnosticFactory.addDiagnosticItemToList(result, "JAX-WS", "", "TITLE");
      for (JaxWsConnectionProvider provider : m_jaxWsConnectionProviderService.getAllConnectionProviders()) {
        String newStateSnapshot = provider.getStats().newStateSnapshot();
        newStateSnapshot = StringUtility.replaceNewLines(newStateSnapshot, "<br>");
        DiagnosticFactory.addDiagnosticItemToList(result, "JAX-WS Connection Provider Status", newStateSnapshot, "INFO");
      }
    }
    catch (Throwable e) {
      DiagnosticFactory.addDiagnosticItemToList(result, "Read JAX-WS Connection provider Stats", "", DiagnosticFactory.STATUS_FAILED);
    }
  }

  @Override
  public String[] getPossibleActions() {
    return null;
  }

  @Override
  public void addSubmitButtonsHTML(List<List<String>> result) {
    //NOP
  }

  @Override
  public void call(String action, Object[] value) {
    //NOP
  }
}
