/*******************************************************************************
 * Copyright (c) 2013 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Ivan Motsch (BSI Business Systems Integration AG) - initial API and implementation
 *     Stephan Leicht Vogt (BSI Business Systems Integration AG) - adaption to JaxWS
 ******************************************************************************/
package org.eclipse.scout.jaxws.service;

import java.util.Collection;

import javax.xml.ws.Service;

import org.eclipse.scout.service.IService;

public interface IJaxWsConnectionProvider extends IService {

  <S extends Service, P> JaxWsConnectionProvider<S, P> getConnectionProvider(IWebServiceClient<S> webServiceClient, Class<? extends P> portTypeClazz);

  Collection<JaxWsConnectionProvider> getAllConnectionProviders();

}
