/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.service.internal;

import java.util.List;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProvider;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProviderService;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticFactory;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;

public class JaxWsConnectionProviderDiagnostic
implements IDiagnostic {
    private final JaxWsConnectionProviderService m_jaxWsConnectionProviderService;

    public JaxWsConnectionProviderDiagnostic(JaxWsConnectionProviderService jaxWsConnectionProviderService) {
        this.m_jaxWsConnectionProviderService = jaxWsConnectionProviderService;
    }

    public void addDiagnosticItemToList(List<List<String>> result) {
        try {
            DiagnosticFactory.addDiagnosticItemToList(result, (String)"JAX-WS", (String)"", (String)"TITLE");
            for (JaxWsConnectionProvider provider : this.m_jaxWsConnectionProviderService.getAllConnectionProviders()) {
                String newStateSnapshot = provider.getStats().newStateSnapshot();
                newStateSnapshot = StringUtility.replaceNewLines((String)newStateSnapshot, (String)"<br>");
                DiagnosticFactory.addDiagnosticItemToList(result, (String)"JAX-WS Connection Provider Status", (String)newStateSnapshot, (String)"INFO");
            }
        }
        catch (Throwable e) {
            DiagnosticFactory.addDiagnosticItemToList(result, (String)"Read JAX-WS Connection provider Stats", (String)"", (String)"FAILED");
        }
    }

    public String[] getPossibleActions() {
        return null;
    }

    public void addSubmitButtonsHTML(List<List<String>> result) {
    }

    public void call(String action, Object[] value) {
    }
}

