/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.service.internal;

import com.sun.xml.ws.client.sei.SEIStub;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.service.IJaxWsConnectionProviderStats;
import org.eclipse.scout.jaxws.service.IWebServiceClient;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProvider;
import org.eclipse.scout.jaxws.service.internal.AbstractJaxWsConnectionProviderStats;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.services.common.session.ISessionService;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.SERVICES;

public class InternalJaxWsConnectionProvider<S extends Service, P>
extends AbstractService
implements IService,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JaxWsConnectionProvider.class);
    protected static final long MILLIS_PER_SECOND = 1000L;
    private final Object m_poolLock;
    private final AbstractJaxWsConnectionProviderStats m_stats;
    private final Map<ISession, HashSet<P>> m_idleEntries;
    private final Map<ISession, HashSet<P>> m_busyEntries;
    private final Map<P, Long> m_whenIsPortTypeCreated;
    private final Map<P, Long> m_whenIsLeaseBegun;
    private final IWebServiceClient<S> m_webServiceClient;
    private final Class<?> m_portTypeClazz;
    private long m_lastStatusDump;
    private long m_statusDumpInterval = 60000L;
    private transient Thread m_managePoolWorker;
    private long m_checkInterval;
    private int m_maxPoolSizePerSession;
    private int m_maxPoolSizeOverAll;
    private long m_connectionMaxAge;
    private long m_connectionMaxAgeOfLastConnectionPerSession;
    private long m_statementBusyTimeout;

    public InternalJaxWsConnectionProvider(IWebServiceClient<S> webServiceClient, Class<? extends P> portTypeClazz) {
        this.m_webServiceClient = webServiceClient;
        this.m_portTypeClazz = portTypeClazz;
        this.m_poolLock = new Object();
        this.m_stats = new AbstractJaxWsConnectionProviderStats(){

            @Override
            public String newStateSnapshot() {
                return InternalJaxWsConnectionProvider.this.createStateSnapshot(InternalJaxWsConnectionProvider.this.m_stats);
            }
        };
        this.m_idleEntries = new HashMap<ISession, HashSet<P>>();
        this.m_busyEntries = new HashMap<ISession, HashSet<P>>();
        this.m_whenIsPortTypeCreated = new HashMap<P, Long>();
        this.m_whenIsLeaseBegun = new HashMap<P, Long>();
        this.setCheckInterval(30000L);
        this.setMaxPoolSizePerSession(5);
        this.setMaxPoolSizeOverAll(5000);
        this.setConnectionMaxAge(600000L);
        this.setStatementBusyTimeout(3600000L);
    }

    protected IJaxWsConnectionProviderStats getStatsImpl() {
        return this.m_stats;
    }

    protected int getMaxPoolSizePerSession() {
        return this.m_maxPoolSizePerSession;
    }

    public void setMaxPoolSizePerSession(int maxPoolSizePerSession) {
        this.m_maxPoolSizePerSession = maxPoolSizePerSession;
    }

    protected int getMaxPoolSizeOverAll() {
        return this.m_maxPoolSizeOverAll;
    }

    public void setMaxPoolSizeOverAll(int maxPoolSizeOverAll) {
        this.m_maxPoolSizeOverAll = maxPoolSizeOverAll;
    }

    protected long getConnectionMaxAge() {
        return this.m_connectionMaxAge;
    }

    public void setConnectionMaxAge(long connectionMaxAge) {
        this.m_connectionMaxAge = connectionMaxAge;
    }

    protected long getConnectionMaxAgeOfLastConnectionPerSession() {
        return this.m_connectionMaxAgeOfLastConnectionPerSession;
    }

    public void setConnectionMaxAgeOfLastConnectionPerSession(long connectionMaxAgeOfLastConnectionPerSession) {
        this.m_connectionMaxAgeOfLastConnectionPerSession = connectionMaxAgeOfLastConnectionPerSession;
    }

    protected long getStatementBusyTimeout() {
        return this.m_statementBusyTimeout;
    }

    public void setStatementBusyTimeout(long statementBusyTimeout) {
        this.m_statementBusyTimeout = statementBusyTimeout;
    }

    protected void setCheckInterval(long checkInterval) {
        this.m_checkInterval = checkInterval;
    }

    protected long getCheckInterval() {
        return this.m_checkInterval;
    }

    public void startHousekeeping() {
        this.m_managePoolWorker = new Thread(String.valueOf(this.getClass().getSimpleName()) + ".managePool"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (InternalJaxWsConnectionProvider.this.m_managePoolWorker == this) {
                    try {
                        Thread.sleep(InternalJaxWsConnectionProvider.this.m_checkInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Object object = InternalJaxWsConnectionProvider.this.m_poolLock;
                    synchronized (object) {
                        InternalJaxWsConnectionProvider.this.managePoolInsideLock(false);
                    }
                }
            }
        };
        this.m_managePoolWorker.setDaemon(true);
        this.m_managePoolWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopHousekeeping() {
        this.m_managePoolWorker = null;
        Object object = this.m_poolLock;
        synchronized (object) {
            this.managePoolInsideLock(true);
        }
    }

    protected int countAllPools() {
        int idleSize = 0;
        for (HashSet<P> idleEntries : this.m_idleEntries.values()) {
            idleSize += idleEntries.size();
        }
        int busySize = 0;
        for (HashSet<P> busyEntries : this.m_busyEntries.values()) {
            busySize += busyEntries.size();
        }
        return idleSize + busySize;
    }

    protected HashSet<P> getBusyEntries(ISession session) {
        HashSet<Object> busyEntries = this.m_busyEntries.get(session);
        if (busyEntries == null) {
            busyEntries = new HashSet();
            this.m_busyEntries.put(session, busyEntries);
        }
        return busyEntries;
    }

    protected HashSet<P> getIdleEntries(ISession session) {
        HashSet<Object> idleEntries = this.m_idleEntries.get(session);
        if (idleEntries == null) {
            idleEntries = new HashSet();
            this.m_idleEntries.put(session, idleEntries);
        }
        return idleEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected P leaseConnection(String url, WebServiceFeature ... usesJAXBContextFeature) {
        ISessionService service = (ISessionService)SERVICES.getService(ISessionService.class);
        if (service == null) {
            throw new IllegalStateException("No session service found!");
        }
        ISession session = service.getCurrentSession();
        if (session == null) {
            throw new IllegalStateException("No session found on session service!");
        }
        int poolSizeOverAll = this.countAllPools();
        HashSet<P> idleEntries = this.getIdleEntries(session);
        HashSet<P> busyEntries = this.getBusyEntries(session);
        Object object = this.m_poolLock;
        synchronized (object) {
            Object portType = null;
            while (true) {
                String portTypeUrl;
                this.managePoolInsideLock(false, session);
                if (!idleEntries.isEmpty() && StringUtility.equalsIgnoreCase((String)url, (String)(portTypeUrl = (String)((BindingProvider)(portType = (Object)idleEntries.iterator().next())).getRequestContext().get("javax.xml.ws.service.endpoint.address")))) break;
                if (idleEntries.size() + busyEntries.size() < this.getMaxPoolSizePerSession() && poolSizeOverAll < this.getMaxPoolSizeOverAll()) {
                    S webService = this.m_webServiceClient.getWebService();
                    Object test = webService.getPort(this.m_portTypeClazz, usesJAXBContextFeature);
                    this.m_whenIsPortTypeCreated.put(test, System.currentTimeMillis());
                    ((BindingProvider)test).getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
                    this.m_stats.connectionOpen();
                    if (LOG.isInfoEnabled()) {
                        LOG.info("created jax ws connection " + test);
                    }
                    idleEntries.add(test);
                    portType = test;
                    break;
                }
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("waiting for connection");
                    }
                    this.dumpWarningStatus();
                    this.m_poolLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            idleEntries.remove(portType);
            busyEntries.add(portType);
            this.m_whenIsPortTypeCreated.put(portType, System.currentTimeMillis());
            if (LOG.isInfoEnabled()) {
                LOG.info("lease   " + portType);
            }
            this.m_stats.connectionLease();
            return (P)portType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseConnection(P portType) {
        ISessionService service = (ISessionService)SERVICES.getService(ISessionService.class);
        if (service == null) {
            throw new IllegalStateException("No session service found!");
        }
        ISession session = service.getCurrentSession();
        if (session == null) {
            throw new IllegalStateException("No session found on session service!");
        }
        HashSet<P> idleEntries = this.getIdleEntries(session);
        HashSet<P> busyEntries = this.getBusyEntries(session);
        InvocationHandler h = Proxy.getInvocationHandler(portType);
        this.m_stats.connectionRelease();
        if (LOG.isInfoEnabled()) {
            LOG.info("release " + h);
        }
        Object object = this.m_poolLock;
        synchronized (object) {
            if (!busyEntries.remove(portType)) {
                this.enqueueCloseConnectionImpl("Closing unknown connection (async)", portType, false);
                return;
            }
            this.m_whenIsLeaseBegun.remove(portType);
            idleEntries.add(portType);
            this.m_poolLock.notifyAll();
        }
    }

    protected void managePoolInsideLock(boolean closeAll) {
        this.managePoolInsideLock(closeAll, null);
    }

    protected void managePoolInsideLock(boolean closeAll, ISession session) {
        try {
            if (session != null) {
                HashSet<P> idleEntries = this.m_idleEntries.get(session);
                this.manageIdleConnections(closeAll, idleEntries);
            } else {
                for (HashSet<P> idleEntries : this.m_idleEntries.values()) {
                    this.manageIdleConnections(closeAll, idleEntries);
                }
            }
            if (!closeAll) {
                if (session != null) {
                    HashSet<P> busyEntries = this.m_busyEntries.get(session);
                    this.manageBusyConnections(closeAll, busyEntries);
                } else {
                    for (HashSet<P> busyEntries : this.m_busyEntries.values()) {
                        this.manageBusyConnections(closeAll, busyEntries);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.warn(null, t);
        }
        if (this.m_stats.getConnectionClosePendingCount() > (long)(this.m_maxPoolSizeOverAll / 2) || this.warnPoolPerSession()) {
            this.dumpWarningStatus();
        }
    }

    private void manageIdleConnections(boolean closeAll, HashSet<P> idleEntries) {
        Iterator<P> it2 = idleEntries.iterator();
        while (it2.hasNext()) {
            P h = it2.next();
            long created = NumberUtility.nvl((Long)this.m_whenIsPortTypeCreated.get(h), (Number)0L);
            if (!closeAll && !this.isLastConnectionAndOlderThanMaxAge(it2, created) && !this.isNotLastConnectionAndOlderThanMaxAge(it2, created)) continue;
            it2.remove();
            this.m_whenIsPortTypeCreated.remove(h);
            this.enqueueCloseConnectionImpl("Close old idle connection (sync)", h, true);
        }
    }

    private void manageBusyConnections(boolean closeAll, HashSet<P> busyEntries) {
        for (P h : busyEntries) {
            long leaseBegin = NumberUtility.nvl((Long)this.m_whenIsLeaseBegun.get(h), (Number)0L);
            if (leaseBegin <= 0L || leaseBegin + this.getStatementBusyTimeout() >= System.currentTimeMillis()) continue;
            LOG.warn("Cancelling timed out statement " + h.toString());
            this.enqueueCancelStatement("Cancelling timed out statement (" + (closeAll ? "sync" : "async") + ")", h, false);
        }
    }

    protected boolean isLastConnectionAndOlderThanMaxAge(Iterator<P> it2, long created) {
        return !it2.hasNext() && created + this.getConnectionMaxAgeOfLastConnectionPerSession() < System.currentTimeMillis();
    }

    protected boolean isNotLastConnectionAndOlderThanMaxAge(Iterator<P> it2, long created) {
        return it2.hasNext() && created + this.getConnectionMaxAge() < System.currentTimeMillis();
    }

    protected boolean warnPoolPerSession() {
        for (HashSet<P> busyEntries : this.m_busyEntries.values()) {
            if (busyEntries.size() <= this.m_maxPoolSizePerSession / 2) continue;
            return true;
        }
        return false;
    }

    protected void enqueueCloseConnectionImpl(final String msg, final P h, boolean sync) {
        this.m_stats.connectionClosePending();
        Runnable job = new Runnable(){

            @Override
            public void run() {
                if (LOG.isInfoEnabled()) {
                    LOG.info(msg);
                }
                SEIStub seiStub = (SEIStub)Proxy.getInvocationHandler(h);
                seiStub.close();
                InternalJaxWsConnectionProvider.this.m_stats.connectionClose();
            }
        };
        if (sync) {
            job.run();
            return;
        }
        Thread t = new Thread(job, msg);
        t.start();
        try {
            t.join(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void enqueueCancelStatement(String msg, final P h, boolean sync) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                try {
                    SEIStub seiStub = (SEIStub)Proxy.getInvocationHandler(h);
                    seiStub.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        if (sync) {
            job.run();
            return;
        }
        Thread t = new Thread(job, msg);
        t.start();
        try {
            t.join(2000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void dumpWarningStatus() {
        long now = System.currentTimeMillis();
        if (this.m_lastStatusDump + this.m_statusDumpInterval >= now) {
            return;
        }
        this.m_lastStatusDump = now;
        LOG.warn(this.getStatsImpl().newStateSnapshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createStateSnapshot(IJaxWsConnectionProviderStats stats) {
        StringBuilder buf = new StringBuilder();
        Object object = this.m_poolLock;
        synchronized (object) {
            buf.append("@@@ " + JaxWsConnectionProvider.class.getName() + " for " + this.m_portTypeClazz.getSimpleName() + " stats\n");
            buf.append("\n");
            buf.append(" maxPoolSizeOverAll: " + this.getMaxPoolSizeOverAll() + "\n");
            buf.append(" maxPoolSizePerSession: " + this.getMaxPoolSizePerSession() + "\n");
            buf.append(" connectionMaxAge: " + this.getConnectionMaxAge() + "\n");
            buf.append(" connectionMaxAgeOfLastConnectionPerSession: " + this.getConnectionMaxAgeOfLastConnectionPerSession() + "\n");
            buf.append(" statementBusyTimeout: " + this.getStatementBusyTimeout() + "\n");
            buf.append("\n");
            buf.append(" connectionCount: " + stats.getConnectionCount() + "\n");
            buf.append(" connectionClosePendingCount: " + stats.getConnectionClosePendingCount() + "\n");
            buf.append(" connectionLeaseCount: " + stats.getConnectionLeaseCount() + "\n");
            buf.append(" connectionReleaseCount: " + stats.getConnectionReleaseCount() + "\n");
            int busyEntryCount = 0;
            for (HashSet<P> busyEntries : this.m_busyEntries.values()) {
                busyEntryCount += busyEntries.size();
            }
            int idleEntryCount = 0;
            for (HashSet<P> idleEntries : this.m_idleEntries.values()) {
                idleEntryCount += idleEntries.size();
            }
            buf.append("Connections: " + busyEntryCount + " busy, " + idleEntryCount + " idle\n");
            for (HashSet<P> busyEntries : this.m_busyEntries.values()) {
                for (P h : busyEntries) {
                    buf.append(" Busy: " + h.toString() + "\n");
                }
            }
            for (HashSet<P> idleEntries : this.m_idleEntries.values()) {
                for (P h : idleEntries) {
                    buf.append(" Idle: " + h.toString() + "\n");
                }
            }
        }
        return buf.toString();
    }
}

