/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.service.internal;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.jaxws.service.IJaxWsConnectionProviderStats;

public abstract class AbstractJaxWsConnectionProviderStats
implements IJaxWsConnectionProviderStats {
    private final AtomicLong m_connectionCount = new AtomicLong();
    private final AtomicLong m_connectionClosePendingCount = new AtomicLong();
    private final AtomicLong m_connectionLeaseCount = new AtomicLong();
    private final AtomicLong m_connectionReleaseCount = new AtomicLong();

    public void connectionOpen() {
        this.m_connectionCount.incrementAndGet();
    }

    public void connectionClosePending() {
        this.m_connectionClosePendingCount.incrementAndGet();
    }

    public void connectionClose() {
        this.m_connectionClosePendingCount.decrementAndGet();
        this.m_connectionCount.decrementAndGet();
    }

    public void connectionLease() {
        this.m_connectionLeaseCount.incrementAndGet();
    }

    public void connectionRelease() {
        this.m_connectionReleaseCount.incrementAndGet();
    }

    @Override
    public long getConnectionCount() {
        return this.m_connectionCount.get();
    }

    @Override
    public long getConnectionClosePendingCount() {
        return this.m_connectionClosePendingCount.get();
    }

    @Override
    public long getConnectionLeaseCount() {
        return this.m_connectionLeaseCount.get();
    }

    @Override
    public long getConnectionReleaseCount() {
        return this.m_connectionReleaseCount.get();
    }

    @Override
    public void resetDeltas() {
        this.m_connectionLeaseCount.set(0L);
        this.m_connectionReleaseCount.set(0L);
    }
}

