/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.Service;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.service.IJaxWsConnectionProvider;
import org.eclipse.scout.jaxws.service.IWebServiceClient;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProvider;
import org.eclipse.scout.jaxws.service.internal.JaxWsConnectionProviderDiagnostic;
import org.eclipse.scout.rt.server.admin.diagnostic.DiagnosticFactory;
import org.eclipse.scout.rt.server.admin.diagnostic.IDiagnostic;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.ServiceRegistration;

public class JaxWsConnectionProviderService
extends AbstractService
implements IJaxWsConnectionProvider {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JaxWsConnectionProvider.class);
    protected static final long MILLIS_PER_SECOND = 1000L;
    private static final boolean DIAGNOSTICS_EXIST;
    private final Map<IWebServiceClient<?>, JaxWsConnectionProvider> m_webServciceConnectionProviderMap = new HashMap();
    private Object m_webServciceConnectionProviderMapLock = new Object();
    private int m_maxPoolSizePerSession;
    private int m_maxPoolSizeOverAll;
    private long m_connectionMaxAge;
    private long m_connectionMaxAgeOfLastConnectionPerSession;
    private long m_statementBusyTimeout;
    private JaxWsConnectionProviderDiagnostic m_diagnostic;

    static {
        boolean diagnosticsExists = false;
        try {
            diagnosticsExists = StringUtility.hasText((String)DiagnosticFactory.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DIAGNOSTICS_EXIST = diagnosticsExists;
    }

    public void initializeService(ServiceRegistration registration) {
        this.initConfig();
        super.initializeService(registration);
        if (DIAGNOSTICS_EXIST) {
            this.m_diagnostic = new JaxWsConnectionProviderDiagnostic(this);
            DiagnosticFactory.addDiagnosticStatusProvider((IDiagnostic)this.m_diagnostic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Service, P> JaxWsConnectionProvider<S, P> getConnectionProvider(IWebServiceClient<S> webServiceClient, Class<? extends P> portTypeClazz) {
        Object object = this.m_webServciceConnectionProviderMapLock;
        synchronized (object) {
            JaxWsConnectionProvider<S, P> connectionProvider = this.m_webServciceConnectionProviderMap.get(webServiceClient);
            if (connectionProvider == null) {
                connectionProvider = new JaxWsConnectionProvider<S, P>(webServiceClient, portTypeClazz);
                connectionProvider.setMaxPoolSizePerSession(this.m_maxPoolSizePerSession);
                connectionProvider.setMaxPoolSizeOverAll(this.m_maxPoolSizeOverAll);
                connectionProvider.setConnectionMaxAge(this.m_connectionMaxAge);
                connectionProvider.setConnectionMaxAgeOfLastConnectionPerSession(this.m_connectionMaxAgeOfLastConnectionPerSession);
                connectionProvider.setStatementBusyTimeout(this.m_statementBusyTimeout);
                connectionProvider.startHousekeeping();
                this.m_webServciceConnectionProviderMap.put(webServiceClient, connectionProvider);
            }
            return connectionProvider;
        }
    }

    @Override
    public Collection<JaxWsConnectionProvider> getAllConnectionProviders() {
        return Collections.unmodifiableCollection(this.m_webServciceConnectionProviderMap.values());
    }

    protected void initConfig() {
        this.setMaxPoolSizePerSession(this.getConfiguredMaxPoolSizePerSession());
        this.setMaxPoolSizeOverAll(this.getConfiguredMaxPoolSizeOverAll());
        this.setConnectionMaxAge(this.getConfiguredConnectionMaxAge());
        this.setConnectionMaxAgeOfLastConnectionPerSession(this.getConfiguredConnectionMaxAgeOfLastConnectionPerSession());
        this.setStatementBusyTimeout(this.getConfiguredStatementBusyTimeout());
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=30.0)
    protected Integer getConfiguredMaxPoolSizePerSession() {
        return 5;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=40.0)
    protected Integer getConfiguredMaxPoolSizeOverAll() {
        return 5000;
    }

    @ConfigProperty(value="LONG")
    @Order(value=50.0)
    protected Long getConfiguredConnectionMaxAge() {
        return 600L;
    }

    @ConfigProperty(value="LONG")
    @Order(value=60.0)
    protected Long getConfiguredConnectionMaxAgeOfLastConnectionPerSession() {
        return 3600L;
    }

    @ConfigProperty(value="LONG")
    @Order(value=70.0)
    protected Long getConfiguredStatementBusyTimeout() {
        return 3600L;
    }

    public int getMaxPoolSizePerSession() {
        return this.m_maxPoolSizePerSession;
    }

    public void setMaxPoolSizePerSession(int configuredMaxPoolSizePerSession) {
        this.m_maxPoolSizePerSession = configuredMaxPoolSizePerSession;
    }

    public int getMaxPoolSizeOverAll() {
        return this.m_maxPoolSizeOverAll;
    }

    public void setMaxPoolSizeOverAll(int configuredMaxPoolSizeOverAll) {
        this.m_maxPoolSizeOverAll = configuredMaxPoolSizeOverAll;
    }

    public long getConnectionMaxAge() {
        return this.m_connectionMaxAge;
    }

    public void setConnectionMaxAge(long connectionMaxAge) {
        this.m_connectionMaxAge = connectionMaxAge * 1000L;
    }

    public long getConnectionMaxAgeOfLastConnectionPerSession() {
        return this.m_connectionMaxAgeOfLastConnectionPerSession;
    }

    public void setConnectionMaxAgeOfLastConnectionPerSession(long connectionMaxAgeOfLastConnectionPerSession) {
        this.m_connectionMaxAgeOfLastConnectionPerSession = connectionMaxAgeOfLastConnectionPerSession * 1000L;
    }

    public long getStatementBusyTimeout() {
        return this.m_statementBusyTimeout;
    }

    public void setStatementBusyTimeout(long statementBusyTimeout) {
        this.m_statementBusyTimeout = statementBusyTimeout * 1000L;
    }

    public void disposeServices() {
        if (DIAGNOSTICS_EXIST) {
            DiagnosticFactory.removeDiagnosticStatusProvider((IDiagnostic)this.m_diagnostic);
        }
        super.disposeServices();
        Iterator<JaxWsConnectionProvider> it = this.m_webServciceConnectionProviderMap.values().iterator();
        while (it.hasNext()) {
            JaxWsConnectionProvider provider = it.next();
            provider.stop();
            it.remove();
        }
    }
}

