/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.jaxws.annotation.ScoutWebServiceClient;
import org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler;
import org.eclipse.scout.jaxws.service.IJaxWsConnectionProvider;
import org.eclipse.scout.jaxws.service.IWebServiceClient;
import org.eclipse.scout.jaxws.service.JaxWsConnectionProvider;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.server.transaction.ITransactionMember;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

@ScoutWebServiceClient
public abstract class AbstractWebServiceClient<S extends Service, P>
extends AbstractService
implements IWebServiceClient<S> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractWebServiceClient.class);
    private WebServiceClient m_webServiceClientAnnotation;
    private String m_transactionMemberId;
    private String m_url;
    private URL m_wsdlLocation;
    private String m_targetNamespace;
    private String m_serviceName;
    private Integer m_requestTimeout;
    private Integer m_connectTimeout;
    private String m_username;
    private String m_password;
    private Class<? extends Service> m_serviceClazz;
    private Class<?> m_portTypeClazz;

    public void initializeService(ServiceRegistration registration) {
        this.m_serviceClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.m_portTypeClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.m_webServiceClientAnnotation = this.m_serviceClazz.getAnnotation(WebServiceClient.class);
        if (this.m_webServiceClientAnnotation == null) {
            throw new WebServiceException("Missing required annotation '" + WebServiceClient.class.getName() + "' on web service client '" + this.getClass().getName() + "'");
        }
        this.initConfig();
        super.initializeService(registration);
    }

    protected void initConfig() {
        String tid = this.getConfiguredTransactionMemberId();
        if (tid == null) {
            tid = String.valueOf(this.getClass().getSimpleName()) + "." + "transaction";
        }
        this.setTransactionMemberId(tid);
        this.setWsdlLocation(this.getConfiguredWsdlLocation());
        this.setUrl(this.getConfiguredUrl());
        this.setTargetNamespace(this.getConfiguredTargetNamespace());
        this.setServiceName(this.getConfiguredServiceName());
        this.setUsername(this.getConfiguredUsername());
        this.setPassword(this.getConfiguredPassword());
        this.setConnectTimeout(this.getConfiguredConnectTimeout());
        this.setRequestTimeout(this.getConfiguredRequestTimeout());
    }

    @Override
    public S getWebService() {
        if (this.getWsdlLocation() == null) {
            throw new WebServiceException("No location for WSDL configured on web service proxy '" + this.getClass().getName() + "'.");
        }
        try {
            Service service;
            ClassLoader backup = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(SerializationUtility.getClassLoader());
                Constructor<? extends Service> constructor = this.m_serviceClazz.getConstructor(URL.class, QName.class);
                service = constructor.newInstance(this.getWsdlLocation(), new QName(this.getTargetNamespace(), this.getServiceName()));
            }
            finally {
                Thread.currentThread().setContextClassLoader(backup);
            }
            service.setHandlerResolver(new HandlerResolver(){

                public List<Handler> getHandlerChain(PortInfo portInfo) {
                    ArrayList<Handler> list = new ArrayList<Handler>();
                    IAuthenticationHandler authenticationHandler = AbstractWebServiceClient.this.createAuthenticationHandler();
                    if (authenticationHandler != null) {
                        try {
                            authenticationHandler.setUsername(AbstractWebServiceClient.this.getUsername());
                            authenticationHandler.setPassword(AbstractWebServiceClient.this.getPassword());
                            if (AbstractWebServiceClient.this.execPrepareAuthenticationHandler(authenticationHandler)) {
                                list.add((Handler)authenticationHandler);
                            }
                        }
                        catch (ProcessingException e) {
                            LOG.error("Authentication handler could not be installed.", (Throwable)e);
                        }
                    }
                    LinkedList<SOAPHandler<SOAPMessageContext>> handlers = new LinkedList<SOAPHandler<SOAPMessageContext>>();
                    AbstractWebServiceClient.this.execInstallHandlers(handlers);
                    if (handlers.size() > 0) {
                        list.addAll(handlers);
                    }
                    return list;
                }
            });
            return (S)service;
        }
        catch (Exception e) {
            throw new WebServiceException("Webservice proxy '" + this.getClass().getName() + "' could not be created.", (Throwable)e);
        }
    }

    public Class<?> getPortTypeClass() {
        return this.m_portTypeClazz;
    }

    public P getPortType() throws ProcessingException {
        return this.getPortType(this.getUrl());
    }

    public P getPortType(String url) throws ProcessingException {
        return this.getConnection(url);
    }

    protected P getConnection(String url) throws ProcessingException {
        if (StringUtility.isNullOrEmpty((String)url)) {
            throw new WebServiceException("No endpoint URL configured for web service client '" + this.getClass().getName() + "'.");
        }
        ITransaction reg = ThreadContext.getTransaction();
        if (reg == null) {
            throw new ProcessingException("no ITransaction available, use ServerJob to run transaction");
        }
        P_JaxWsTransactionMember member = (P_JaxWsTransactionMember)reg.getMember(this.getTransactionMemberId());
        if (member == null) {
            try {
                P conn = this.leaseConnection(url);
                member = new P_JaxWsTransactionMember(this.getTransactionMemberId(), conn);
                reg.registerMember((ITransactionMember)member);
                this.execBeginTransaction();
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ProcessingException("getTransaction", e);
            }
        }
        return member.getConnection();
    }

    private P leaseConnection(String url) throws Throwable {
        P conn = this.execCreateConnection(url);
        return conn;
    }

    private void releaseConnection(P conn) {
        try {
            this.execReleaseConnection(conn);
        }
        catch (Throwable e) {
            LOG.error(null, e);
        }
    }

    private void releaseConnectionInternal(P conn) throws Throwable {
        JaxWsConnectionProvider connectionProvider = ((IJaxWsConnectionProvider)SERVICES.getService(IJaxWsConnectionProvider.class)).getConnectionProvider(this, this.m_portTypeClazz);
        connectionProvider.closeConnection(conn);
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execAfterConnectionCreated(P conn) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execBeginTransaction() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected P execCreateConnection(String url) throws Throwable {
        JaxWsConnectionProvider connectionProvider = ((IJaxWsConnectionProvider)SERVICES.getService(IJaxWsConnectionProvider.class)).getConnectionProvider(this, this.m_portTypeClazz);
        Object portType = connectionProvider.getConnection(url, new WebServiceFeature[0]);
        if (NumberUtility.nvl((Integer)this.getRequestTimeout(), (Number)0) > 0) {
            ((BindingProvider)portType).getRequestContext().put("com.sun.xml.ws.request.timeout", this.getRequestTimeout());
        }
        if (NumberUtility.nvl((Integer)this.getConnectTimeout(), (Number)0) > 0) {
            ((BindingProvider)portType).getRequestContext().put("com.sun.xml.ws.connect.timeout", this.getConnectTimeout());
        }
        return (P)portType;
    }

    @ConfigOperation
    @Order(value=35.0)
    protected void execReleaseConnection(P conn) throws Throwable {
        this.releaseConnectionInternal(conn);
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execEndTransaction(boolean willBeCommitted) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    public boolean execPreCommit(P conn) {
        return true;
    }

    @ConfigOperation
    @Order(value=70.0)
    public void execCommit(P conn) {
    }

    @ConfigOperation
    @Order(value=80.0)
    public void execRollback(P conn) {
    }

    @ConfigProperty(value="STRING")
    @Order(value=90.0)
    protected String getConfiguredTransactionMemberId() {
        return null;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=20.0)
    protected URL getConfiguredWsdlLocation() {
        String wsdlLocation = this.m_webServiceClientAnnotation.wsdlLocation();
        if (StringUtility.isNullOrEmpty((String)wsdlLocation)) {
            throw new WebServiceException("No WSDL file location configured on web service proxy '" + this.getClass().getName() + "'");
        }
        IPath path = new Path("").addTrailingSeparator().append((IPath)new Path(wsdlLocation));
        URL urlWsdlLocation = this.getClass().getResource(path.toPortableString());
        if (urlWsdlLocation == null) {
            throw new WebServiceException("Could not find WSDL file '" + StringUtility.nvl((Object)wsdlLocation, (String)"?") + "' of web service client '" + this.getClass().getName() + "'");
        }
        return urlWsdlLocation;
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    protected String getConfiguredUrl() {
        return null;
    }

    @Order(value=40.0)
    protected String getConfiguredServiceName() {
        return this.m_webServiceClientAnnotation.name();
    }

    @Order(value=50.0)
    protected String getConfiguredTargetNamespace() {
        return this.m_webServiceClientAnnotation.targetNamespace();
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    protected String getConfiguredUsername() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=70.0)
    protected String getConfiguredPassword() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=80.0)
    protected Integer getConfiguredConnectTimeout() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=90.0)
    protected Integer getConfiguredRequestTimeout() {
        return null;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected boolean execPrepareAuthenticationHandler(IAuthenticationHandler authenticationHandler) throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execInstallHandlers(List<SOAPHandler<SOAPMessageContext>> handlers) {
    }

    private IAuthenticationHandler createAuthenticationHandler() {
        ScoutWebServiceClient annotation = null;
        Class<?> declaringClass = this.getClass();
        while (annotation == null && declaringClass != null && declaringClass != Object.class) {
            annotation = declaringClass.getAnnotation(ScoutWebServiceClient.class);
            declaringClass = declaringClass.getSuperclass();
        }
        if (annotation == null) {
            return null;
        }
        Class<? extends IAuthenticationHandler> authenticationHandlerClazz = annotation.authenticationHandler();
        if (authenticationHandlerClazz == null || authenticationHandlerClazz == IAuthenticationHandler.NONE.class) {
            return null;
        }
        IAuthenticationHandler authenticationHandler = null;
        try {
            authenticationHandler = authenticationHandlerClazz.newInstance();
        }
        catch (Exception e) {
            LOG.error("Failed to instantiate authentication handler '" + authenticationHandlerClazz.getName() + "'.", (Throwable)e);
            return null;
        }
        return authenticationHandler;
    }

    @Override
    public String getTransactionMemberId() {
        return this.m_transactionMemberId;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public String getTargetNamespace() {
        return this.m_targetNamespace;
    }

    @Override
    public URL getWsdlLocation() {
        return this.m_wsdlLocation;
    }

    public void setTransactionMemberId(String s) {
        this.m_transactionMemberId = s;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public void setTargetNamespace(String targetNamespace) {
        this.m_targetNamespace = targetNamespace;
    }

    @Override
    public Integer getRequestTimeout() {
        return this.m_requestTimeout;
    }

    @Override
    public void setRequestTimeout(Integer requestTimeout) {
        this.m_requestTimeout = requestTimeout;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.m_connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.m_connectTimeout = connectTimeout;
    }

    @Override
    public void setWsdlLocation(URL wsdlLocation) {
        this.m_wsdlLocation = wsdlLocation;
    }

    @Override
    public String getUrl() {
        return this.m_url;
    }

    @Override
    public void setUrl(String url) {
        this.m_url = url;
    }

    private final class P_JaxWsTransactionMember
    extends AbstractTransactionMember {
        private final P m_conn;
        private boolean m_finishingTransaction;

        public P_JaxWsTransactionMember(String transactionMemberId, P conn) {
            super(transactionMemberId);
            this.m_conn = conn;
        }

        public P getConnection() {
            return this.m_conn;
        }

        protected void setFinishingTransaction(boolean finishingTransaction) {
            this.m_finishingTransaction = finishingTransaction;
        }

        public boolean needsCommit() {
            return true;
        }

        public boolean commitPhase1() {
            return AbstractWebServiceClient.this.execPreCommit(this.m_conn);
        }

        public void commitPhase2() {
            try {
                try {
                    this.setFinishingTransaction(true);
                    AbstractWebServiceClient.this.execEndTransaction(false);
                }
                finally {
                    this.setFinishingTransaction(false);
                }
                AbstractWebServiceClient.this.execCommit(this.m_conn);
            }
            catch (Exception e) {
                LOG.error(null, (Throwable)e);
            }
        }

        public void rollback() {
            block6: {
                try {
                    try {
                        this.setFinishingTransaction(true);
                        AbstractWebServiceClient.this.execEndTransaction(false);
                    }
                    finally {
                        this.setFinishingTransaction(false);
                    }
                    AbstractWebServiceClient.this.execRollback(this.m_conn);
                }
                catch (Exception e) {
                    if (ThreadContext.getTransaction().isCancelled()) break block6;
                    LOG.error(null, (Throwable)e);
                }
            }
        }

        public void release() {
            AbstractWebServiceClient.this.releaseConnection(this.m_conn);
        }
    }
}

