/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security.provider;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.internal.ContextHelper;
import org.eclipse.scout.jaxws.internal.SessionHelper;
import org.eclipse.scout.jaxws.security.Authenticator;
import org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler;
import org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.service.ServiceUtility;

@ScoutTransaction
public class WsseUsernameTokenAuthenticationHandler
implements IAuthenticationHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WsseUsernameTokenAuthenticationHandler.class);
    private static final String WSSE = "wsse";
    private static final String WS_SEC = "Security";
    private static final String USERNAME_TOKEN = "UsernameToken";
    private static final String USERNAME = "Username";
    private static final String PASSWORD = "Password";
    private static final String NAME_SPACE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private ICredentialValidationStrategy m_credentialValidationStrategy;

    public WsseUsernameTokenAuthenticationHandler() {
        ServiceUtility.injectConfigProperties((Object)this);
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        block7: {
            boolean outbound = (Boolean)TypeCastUtility.castValue((Object)context.get((Object)"javax.xml.ws.handler.message.outbound"), Boolean.TYPE);
            if (outbound) {
                return true;
            }
            if (Authenticator.isSubjectAuthenticated()) {
                return true;
            }
            try {
                SOAPHeader header = context.getMessage().getSOAPPart().getEnvelope().getHeader();
                if (header == null) {
                    throw new WebServiceException("Authentication failed as no WSSE-Security header found.");
                }
                if (!this.authenticateRequest(header)) break block7;
                IServerSessionFactory portTypeSessionFactory = ContextHelper.getPortTypeSessionFactory((MessageContext)context);
                IServerSession serverSession = SessionHelper.createNewServerSession(portTypeSessionFactory);
                if (serverSession != null) {
                    ContextHelper.setContextSession((MessageContext)context, portTypeSessionFactory, serverSession);
                }
                return true;
            }
            catch (Exception e) {
                return this.breakHandlerChainWithException(context, e);
            }
        }
        return this.breakHandlerChain(context);
    }

    @Override
    public void injectCredentialValidationStrategy(ICredentialValidationStrategy strategy) {
        this.m_credentialValidationStrategy = strategy;
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(new QName(NAME_SPACE_URI, WS_SEC));
        return headers;
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean authenticateRequest(SOAPHeader header) throws Exception {
        iteratorSecurity = header.getChildElements(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse"));
        if (iteratorSecurity.hasNext()) ** GOTO lbl17
        throw new WebServiceException("Authentication failed as no WSSE-Security header found.");
lbl-1000:
        // 1 sources

        {
            security = (SOAPElement)iteratorSecurity.next();
            iteratorUserToken = security.getChildElements(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken", "wsse"));
            while (iteratorUserToken.hasNext()) {
                userTokenElement = (SOAPElement)iteratorUserToken.next();
                iteratorUsername = userTokenElement.getChildElements(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Username", "wsse"));
                iteratorPassword = userTokenElement.getChildElements(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Password", "wsse"));
                if (!iteratorUsername.hasNext() || !iteratorPassword.hasNext()) continue;
                usernameElement = (SOAPElement)iteratorUsername.next();
                passwordElement = (SOAPElement)iteratorPassword.next();
                if (usernameElement == null || passwordElement == null) continue;
                username = usernameElement.getValue();
                passwordPlainText = passwordElement.getValue();
                return Authenticator.authenticateRequest(this.m_credentialValidationStrategy, username, passwordPlainText);
            }
lbl17:
            // 2 sources

            ** while (iteratorSecurity.hasNext())
        }
lbl18:
        // 1 sources

        return false;
    }

    protected boolean breakHandlerChain(SOAPMessageContext context) {
        context.put((Object)"javax.xml.ws.http.response.code", (Object)401);
        boolean oneway = BooleanUtility.nvl((Boolean)((Boolean)context.get((Object)"com.sun.xml.ws.server.OneWayOperation")), (boolean)false);
        if (oneway) {
            throw new WebServiceException("Unauthorized");
        }
        return false;
    }

    protected boolean breakHandlerChainWithException(SOAPMessageContext context, Exception exception) {
        context.put((Object)"javax.xml.ws.http.response.code", (Object)500);
        LOG.error("Internal server error (Message Level WS-Security with UsernameToken authentication)", (Throwable)exception);
        if (exception instanceof WebServiceException) {
            throw (WebServiceException)exception;
        }
        throw new WebServiceException("Internal server error");
    }

    @Override
    public String getName() {
        return "WSSE Username Token";
    }
}

