/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security.consumer;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.security.consumer.IAuthenticationHandler;

public class WsseUsernameTokenAuthenticationHandler
implements IAuthenticationHandler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WsseUsernameTokenAuthenticationHandler.class);
    private static final String WSSE = "wsse";
    private static final String WS_SEC = "Security";
    private static final String USERNAME_TOKEN = "UsernameToken";
    private static final String USERNAME = "Username";
    private static final String PASSWORD = "Password";
    private static final String NAME_SPACE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    protected String m_username;
    protected String m_password;

    public final boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)TypeCastUtility.castValue((Object)context.get((Object)"javax.xml.ws.handler.message.outbound"), Boolean.TYPE);
        if (!outbound) {
            return true;
        }
        if (this.m_username == null || this.m_password == null) {
            throw new WebServiceException("Invalid credentials configured.");
        }
        try {
            SOAPEnvelope envelope = context.getMessage().getSOAPPart().getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                header = envelope.addHeader();
            }
            this.installAuthHeader(header);
            return true;
        }
        catch (SOAPException e) {
            LOG.error("Unable to add wss security token", (Throwable)e);
            return false;
        }
    }

    protected void installAuthHeader(SOAPHeader header) throws SOAPException {
        SOAPElement security = header.addChildElement(WS_SEC, WSSE, NAME_SPACE_URI);
        SOAPElement userToken = security.addChildElement(USERNAME_TOKEN, WSSE);
        userToken.addChildElement(USERNAME, WSSE).addTextNode(this.m_username);
        userToken.addChildElement(PASSWORD, WSSE).addTextNode(this.m_password);
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(new QName(NAME_SPACE_URI, WS_SEC));
        return headers;
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }
}

