/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.tube;

import com.sun.xml.ws.api.handler.MessageHandler;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.annotation.ScoutWebService;
import org.eclipse.scout.jaxws.handler.internal.ScoutTransactionLogicalHandlerWrapper;
import org.eclipse.scout.jaxws.handler.internal.ScoutTransactionMessageHandlerWrapper;
import org.eclipse.scout.jaxws.handler.internal.ScoutTransactionSOAPHandlerWrapper;
import org.eclipse.scout.jaxws.internal.ContextHelper;
import org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler;
import org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy;
import org.eclipse.scout.jaxws.session.IServerSessionFactory;

public class ScoutTubelineAssembler
implements TubelineAssembler {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutTubelineAssembler.class);

    public Tube createClient(ClientTubeAssemblerContext context) {
        this.wrapScoutTransactionHandlers((Binding)context.getBinding());
        Tube head = context.createTransportTube();
        head = context.createSecurityTube(head);
        head = context.createWsaTube(head);
        head = context.createClientMUTube(head);
        head = context.createValidationTube(head);
        return context.createHandlerTube(head);
    }

    public Tube createServer(ServerTubeAssemblerContext context) {
        this.installServerAuthenticationHandler(context);
        this.wrapScoutTransactionHandlers((Binding)context.getEndpoint().getBinding());
        Tube head = context.getTerminalTube();
        head = context.createValidationTube(head);
        head = context.createHandlerTube(head);
        head = context.createMonitoringTube(head);
        head = context.createServerMUTube(head);
        head = context.createWsaTube(head);
        head = context.createSecurityTube(head);
        return head;
    }

    private void wrapScoutTransactionHandlers(Binding binding) {
        ArrayList<Handler> handlerChain = new ArrayList<Handler>();
        for (Handler handler : binding.getHandlerChain()) {
            ScoutTransaction annotation;
            if ((handler instanceof LogicalHandler || handler instanceof SOAPHandler || handler instanceof MessageHandler) && (annotation = this.getAnnotation(handler.getClass(), ScoutTransaction.class)) != null) {
                handler = this.createScoutTransactionHandlerWrapper(handler, annotation);
            }
            handlerChain.add(handler);
        }
        binding.setHandlerChain(handlerChain);
    }

    private Handler createScoutTransactionHandlerWrapper(Handler handler, ScoutTransaction scoutTransaction) {
        if (scoutTransaction == null || handler == null) {
            return handler;
        }
        if (handler instanceof LogicalHandler) {
            return new ScoutTransactionLogicalHandlerWrapper((LogicalHandler)handler, scoutTransaction);
        }
        if (handler instanceof SOAPHandler) {
            return new ScoutTransactionSOAPHandlerWrapper((SOAPHandler)handler, scoutTransaction);
        }
        if (handler instanceof MessageHandler) {
            return new ScoutTransactionMessageHandlerWrapper((MessageHandler)handler, scoutTransaction);
        }
        LOG.warn("Unsupported handler type  '" + handler.getClass().getName() + "' for Scout transaction.");
        return handler;
    }

    private void installServerAuthenticationHandler(ServerTubeAssemblerContext context) {
        LinkedList<Object> handlerChain = new LinkedList<Object>();
        handlerChain.addAll(context.getEndpoint().getBinding().getHandlerChain());
        IAuthenticationHandler authenticationHandler = this.createAuthenticationHandler(context);
        if (authenticationHandler != null) {
            handlerChain.add(authenticationHandler);
        }
        Class portTypeClass = context.getEndpoint().getImplementationClass();
        try {
            ScoutWebService scoutWebService;
            if (portTypeClass != null && (scoutWebService = portTypeClass.getAnnotation(ScoutWebService.class)) != null) {
                handlerChain.add(new P_PortTypeSessionFactoryRegistrationHandler(scoutWebService));
            }
        }
        catch (Exception e) {
            LOG.error("failed to install handler to register configured port type factory in running context", (Throwable)e);
        }
        context.getEndpoint().getBinding().setHandlerChain(handlerChain);
    }

    private IAuthenticationHandler createAuthenticationHandler(ServerTubeAssemblerContext context) {
        Class wsImplClazz = context.getEndpoint().getImplementationClass();
        if (wsImplClazz == null) {
            return null;
        }
        ScoutWebService annotation = this.getAnnotation(wsImplClazz, ScoutWebService.class);
        if (annotation == null) {
            return null;
        }
        Class<? extends IAuthenticationHandler> authenticationHandlerClazz = annotation.authenticationHandler();
        if (authenticationHandlerClazz == null || authenticationHandlerClazz == IAuthenticationHandler.NONE.class) {
            return null;
        }
        IAuthenticationHandler authenticationHandler = null;
        try {
            authenticationHandler = authenticationHandlerClazz.newInstance();
        }
        catch (Throwable e) {
            LOG.error("Failed to create authentication handler '" + authenticationHandlerClazz.getName() + "'. No authentication is applied.", e);
            return null;
        }
        Class<? extends ICredentialValidationStrategy> strategyClazz = annotation.credentialValidationStrategy();
        if (strategyClazz == null) {
            return authenticationHandler;
        }
        ICredentialValidationStrategy strategy = null;
        try {
            strategy = strategyClazz.newInstance();
        }
        catch (Throwable e) {
            LOG.error("Failed to create credential validation strategy '" + strategyClazz.getName() + "' for authentication handler '" + authenticationHandler.getClass().getName() + "'.", e);
            return authenticationHandler;
        }
        try {
            authenticationHandler.injectCredentialValidationStrategy(strategy);
        }
        catch (Throwable e) {
            LOG.error("Failed to inject credential validation strategy to authentication handler '" + authenticationHandler.getClass().getName() + "'.", e);
            return authenticationHandler;
        }
        return authenticationHandler;
    }

    private <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationClazz) {
        A annotation = type.getAnnotation(annotationClazz);
        if (annotation == null && type != Object.class) {
            return this.getAnnotation(type.getSuperclass(), annotationClazz);
        }
        return annotation;
    }

    private class P_PortTypeSessionFactoryRegistrationHandler
    implements SOAPHandler<SOAPMessageContext> {
        private ScoutWebService m_scoutWebServiceAnnotation;

        private P_PortTypeSessionFactoryRegistrationHandler(ScoutWebService scoutWebServiceAnnotation) {
            this.m_scoutWebServiceAnnotation = scoutWebServiceAnnotation;
        }

        public boolean handleMessage(SOAPMessageContext context) {
            boolean outbound = (Boolean)TypeCastUtility.castValue((Object)context.get((Object)"javax.xml.ws.handler.message.outbound"), Boolean.TYPE);
            if (outbound) {
                return true;
            }
            try {
                IServerSessionFactory portTypeSessionFactory = this.m_scoutWebServiceAnnotation.sessionFactory().newInstance();
                ContextHelper.setPortTypeSessionFactory((MessageContext)context, portTypeSessionFactory);
            }
            catch (Exception e) {
                LOG.error("Failed to put port type session factory into the running context", (Throwable)e);
            }
            return true;
        }

        public boolean handleFault(SOAPMessageContext context) {
            return true;
        }

        public void close(MessageContext context) {
        }

        public Set<QName> getHeaders() {
            return new HashSet<QName>();
        }
    }
}

