/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class JaxWsHelper {
    private JaxWsHelper() {
    }

    public static String getBaseAddress(HttpServletRequest request, boolean includeContextPath) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getScheme());
        builder.append("://");
        builder.append(request.getServerName());
        builder.append(':');
        builder.append(request.getServerPort());
        if (includeContextPath) {
            builder.append(request.getContextPath());
        }
        return builder.toString();
    }

    public static Map<String, List<String>> cloneHeaderMap(Map<String, List<String>> headers) {
        HashMap<String, List<String>> clone = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> headerEntry : headers.entrySet()) {
            String name = headerEntry.getKey();
            List<String> values = headerEntry.getValue();
            clone.put(name, new ArrayList<String>(values));
        }
        return clone;
    }
}

