/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.jaxws.Activator;
import org.eclipse.scout.jaxws.internal.resources.AbstractResolver;
import org.osgi.framework.Bundle;

public class BundleProxyClassLoader
extends ClassLoader {
    private static final Logger LOG = Logger.getLogger("com.sun.xml.ws.server.http");
    private Bundle m_bundle;

    public BundleProxyClassLoader(Bundle bundle) {
        this.m_bundle = bundle;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = (Class)new P_FindClassResolver(name, Activator.getDefault().getBundle(), this.m_bundle).resolve();
        if (clazz != null) {
            return clazz;
        }
        return SerializationUtility.getClassLoader().loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        URL url = (URL)new P_FindResourceResolver(name, Activator.getDefault().getBundle(), this.m_bundle).resolve();
        if (url != null) {
            return url;
        }
        return SerializationUtility.getClassLoader().getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration e = (Enumeration)new P_FindResourcesResolver(name, Activator.getDefault().getBundle(), this.m_bundle).resolve();
        if (e != null) {
            return e;
        }
        return SerializationUtility.getClassLoader().getResources(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration e = (Enumeration)new P_GetResourcesResolver(name, Activator.getDefault().getBundle(), this.m_bundle).resolve();
        if (e != null) {
            return e;
        }
        return SerializationUtility.getClassLoader().getResources(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = (URL)new P_GetResourceResolver(name, Activator.getDefault().getBundle(), this.m_bundle).resolve();
        if (url != null) {
            return url;
        }
        return SerializationUtility.getClassLoader().getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = (InputStream)new P_GetResourceAsStream(name, Activator.getDefault().getBundle(), this.m_bundle).resolve();
        if (is != null) {
            return is;
        }
        return SerializationUtility.getClassLoader().getResourceAsStream(name);
    }

    private class P_FindClassResolver
    extends AbstractResolver<Class<?>> {
        private String m_name;

        public P_FindClassResolver(String name, Bundle ... bundles) {
            super(bundles);
            this.m_name = name;
        }

        @Override
        public Class<?> resolve(Bundle bundle) throws AbstractResolver.ResourceNotFoundException {
            try {
                return bundle.loadClass(this.m_name);
            }
            catch (Exception e) {
                throw new AbstractResolver.ResourceNotFoundException();
            }
        }
    }

    private class P_FindResourceResolver
    extends AbstractResolver<URL> {
        private String m_name;

        public P_FindResourceResolver(String name, Bundle ... bundles) {
            super(bundles);
            this.m_name = name;
        }

        @Override
        public URL resolve(Bundle bundle) throws AbstractResolver.ResourceNotFoundException {
            URL url = bundle.getResource(this.m_name);
            if (url != null) {
                return url;
            }
            throw new AbstractResolver.ResourceNotFoundException();
        }
    }

    private class P_FindResourcesResolver
    extends AbstractResolver<Enumeration<URL>> {
        private String m_name;

        public P_FindResourcesResolver(String name, Bundle ... bundles) {
            super(bundles);
            this.m_name = name;
        }

        @Override
        public Enumeration<URL> resolve(Bundle bundle) throws AbstractResolver.ResourceNotFoundException {
            try {
                Enumeration urls = bundle.getResources(this.m_name);
                if (urls != null && urls.hasMoreElements()) {
                    return urls;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AbstractResolver.ResourceNotFoundException();
        }

        @Override
        public Enumeration<URL> resolveEmpty() {
            return Collections.enumeration(new ArrayList(0));
        }
    }

    private class P_GetResourceAsStream
    extends AbstractResolver<InputStream> {
        private String m_name;

        public P_GetResourceAsStream(String name, Bundle ... bundles) {
            super(bundles);
            this.m_name = name;
        }

        @Override
        public InputStream resolve(Bundle bundle) throws AbstractResolver.ResourceNotFoundException {
            URL url = bundle.getResource(this.m_name);
            if (url != null) {
                try {
                    return url.openStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AbstractResolver.ResourceNotFoundException();
        }
    }

    private class P_GetResourceResolver
    extends AbstractResolver<URL> {
        private String m_name;

        public P_GetResourceResolver(String name, Bundle ... bundles) {
            super(bundles);
            this.m_name = name;
        }

        @Override
        public URL resolve(Bundle bundle) throws AbstractResolver.ResourceNotFoundException {
            URL url = bundle.getResource(this.m_name);
            if (url != null) {
                return url;
            }
            throw new AbstractResolver.ResourceNotFoundException();
        }
    }

    private class P_GetResourcesResolver
    extends AbstractResolver<Enumeration<URL>> {
        private String m_name;

        public P_GetResourcesResolver(String name, Bundle ... bundles) {
            super(bundles);
            this.m_name = name;
        }

        @Override
        public Enumeration<URL> resolve(Bundle bundle) throws AbstractResolver.ResourceNotFoundException {
            try {
                Enumeration urls = bundle.getResources(this.m_name);
                if (urls != null && urls.hasMoreElements()) {
                    return urls;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new AbstractResolver.ResourceNotFoundException();
        }

        @Override
        public Enumeration<URL> resolveEmpty() {
            return Collections.enumeration(new ArrayList(0));
        }
    }
}

