/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.handler.internal;

import com.sun.xml.ws.api.handler.MessageHandler;
import com.sun.xml.ws.api.handler.MessageHandlerContext;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import org.eclipse.scout.commons.RunnableWithException;
import org.eclipse.scout.jaxws.annotation.ScoutTransaction;
import org.eclipse.scout.jaxws.handler.internal.IScoutTransactionHandlerWrapper;
import org.eclipse.scout.jaxws.internal.ScoutTransactionDelegate;

public class ScoutTransactionMessageHandlerWrapper<T extends MessageHandlerContext>
implements MessageHandler<T>,
IScoutTransactionHandlerWrapper<T> {
    protected final ScoutTransactionDelegate m_transactionDelegate;
    protected final MessageHandler<T> m_messageHandler;

    public ScoutTransactionMessageHandlerWrapper(MessageHandler<T> messageHandler, ScoutTransaction scoutTransaction) {
        this.m_transactionDelegate = this.createTransactionDelegate(scoutTransaction);
        this.m_messageHandler = messageHandler;
    }

    public boolean handleMessage(final T context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                return ScoutTransactionMessageHandlerWrapper.this.m_messageHandler.handleMessage((MessageContext)context);
            }
        };
        return this.m_transactionDelegate.runInTransaction(runnable, (MessageContext)context);
    }

    public boolean handleFault(final T context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                return ScoutTransactionMessageHandlerWrapper.this.m_messageHandler.handleFault((MessageContext)context);
            }
        };
        return this.m_transactionDelegate.runInTransaction(runnable, (MessageContext)context);
    }

    public void close(final MessageContext context) {
        RunnableWithException<Boolean> runnable = new RunnableWithException<Boolean>(){

            public Boolean run() throws Throwable {
                ScoutTransactionMessageHandlerWrapper.this.m_messageHandler.close(context);
                return null;
            }
        };
        this.m_transactionDelegate.runInTransaction(runnable, context);
    }

    public Set<QName> getHeaders() {
        return this.m_messageHandler.getHeaders();
    }

    protected ScoutTransactionDelegate createTransactionDelegate(ScoutTransaction scoutTransaction) {
        return new ScoutTransactionDelegate(scoutTransaction);
    }

    @Override
    public Handler<T> getHandler() {
        return this.m_messageHandler;
    }
}

