/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.adapters;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class UtcDateAdapter
extends XmlAdapter<String, Date> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UtcDateAdapter.class);

    public String marshal(Date date) throws Exception {
        if (date == null) {
            return null;
        }
        long utcMillis = date.getTime();
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(utcMillis);
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = factory.newXMLGregorianCalendar(calendar);
        return xmlCalendar.toXMLFormat();
    }

    public Date unmarshal(String rawValue) throws Exception {
        if (!StringUtility.hasText((String)rawValue)) {
            return null;
        }
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = factory.newXMLGregorianCalendar(rawValue);
        GregorianCalendar calendar = xmlCalendar.toGregorianCalendar();
        long utcMillis = calendar.getTimeInMillis();
        Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCalendar.setTimeInMillis(utcMillis);
        return utcCalendar.getTime();
    }
}

