/*******************************************************************************
 * Copyright (c) 2013 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Ivan Motsch (BSI Business Systems Integration AG) - initial API and implementation
 *     Stephan Leicht Vogt (BSI Business Systems Integration AG) - adaption to JaxWS
 ******************************************************************************/
package org.eclipse.scout.jaxws.service.internal;

import java.util.concurrent.atomic.AtomicLong;

import org.eclipse.scout.jaxws.service.IJaxWsConnectionProviderStats;

public abstract class AbstractJaxWsConnectionProviderStats implements IJaxWsConnectionProviderStats {
  private final AtomicLong m_connectionCount = new AtomicLong();
  private final AtomicLong m_connectionClosePendingCount = new AtomicLong();
  private final AtomicLong m_connectionLeaseCount = new AtomicLong();
  private final AtomicLong m_connectionReleaseCount = new AtomicLong();

  public void connectionOpen() {
    m_connectionCount.incrementAndGet();
  }

  public void connectionClosePending() {
    m_connectionClosePendingCount.incrementAndGet();
  }

  public void connectionClose() {
    m_connectionClosePendingCount.decrementAndGet();
    m_connectionCount.decrementAndGet();
  }

  public void connectionLease() {
    m_connectionLeaseCount.incrementAndGet();
  }

  public void connectionRelease() {
    m_connectionReleaseCount.incrementAndGet();
  }

  @Override
  public long getConnectionCount() {
    return m_connectionCount.get();
  }

  @Override
  public long getConnectionClosePendingCount() {
    return m_connectionClosePendingCount.get();
  }

  @Override
  public long getConnectionLeaseCount() {
    return m_connectionLeaseCount.get();
  }

  @Override
  public long getConnectionReleaseCount() {
    return m_connectionReleaseCount.get();
  }

  @Override
  public void resetDeltas() {
    m_connectionLeaseCount.set(0);
    m_connectionReleaseCount.set(0);
  }
}
