/*******************************************************************************
 * Copyright (c) 2013 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Ivan Motsch (BSI Business Systems Integration AG) - initial API and implementation
 *     Stephan Leicht Vogt (BSI Business Systems Integration AG) - adaption to JaxWS
 ******************************************************************************/
package org.eclipse.scout.jaxws.service;

import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.jaxws.service.internal.InternalJaxWsConnectionProvider;

/**
 * System-wide connection pool for pooling connections There is one pool for
 * every ISqlService sub class type If possible, every scout Session is provided
 * with always the same connection it had in the last request this class is
 * thread-safe
 */
public class JaxWsConnectionProvider<S extends Service, P> extends InternalJaxWsConnectionProvider {
  private static final long serialVersionUID = 1L;
  private static final IScoutLogger LOG = ScoutLogManager.getLogger(JaxWsConnectionProvider.class);//all connection provider classes use log of JaxWsConnectionProvider

  @SuppressWarnings("unchecked")
  public JaxWsConnectionProvider(IWebServiceClient<S> webServiceClient, Class<? extends P> portTypeClazz) {
    super(webServiceClient, portTypeClazz);
  }

  /**
   * @returns the reference to the life stats object. The object is finally attached to this connection provider, hence
   *          it will never be dereferenced.
   */
  public IJaxWsConnectionProviderStats getStats() {
    return super.getStatsImpl();
  }

  public void closeAllConnections() {
    managePoolInsideLock(true);
  }

  @SuppressWarnings("unchecked")
  public P getConnection(String url, WebServiceFeature... usesJAXBContextFeature) {
    return (P) leaseConnection(url, usesJAXBContextFeature);
  }

  @SuppressWarnings("unchecked")
  public void closeConnection(P portType) {
    releaseConnection(portType);
  }

  public void stop() {
    stopHousekeeping();
  }
}
