/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal.update.win32.elev;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

import org.eclipse.update.f2.internal.update.UpdateContext;
import org.eclipse.update.f2.internal.update.win32.TestWin32UpdateCommitter;
import org.eclipse.update.f2.internal.update.win32.Win32UpdateCommitter;

/**
 * Required system properties, file names have spaces encoded as %20
 * <ul>
 * <li>{@link #UPDATE_TEMP_DIR}</li>
 * <li>{@link #UPDATE_APP_NAME}</li>
 * <li>{@link #UPDATE_INSTALL_ROOT_DIR}</li>
 * <li>{@link #UPDATE_OLD_VERSION}</li>
 * <li>{@link #UPDATE_NEW_VERSION}</li>
 * </ul>
 */
public final class Win32ElevationTarget {
  public static final String WIN_ELEV_KEY = "winelev";
  public static final String WIN_ELEV_VALUE_RUN = "run";
  public static final String WIN_ELEV_VALUE_TEST = "junit";
  public static final String WIN_ELEV_LOG_FILE_NAME = "winelev-log.txt";
  public static final String WIN_ELEV_SUCCESS_TOKEN = "[SUCCESS]";

  public static final String UPDATE_TEMP_DIR = "update.tmpDir";
  public static final String UPDATE_APP_NAME = "update.appName";
  public static final String UPDATE_INSTALL_ROOT_DIR = "update.installRootDir";
  public static final String UPDATE_OLD_VERSION = "update.oldVersion";
  public static final String UPDATE_NEW_VERSION = "update.newVersion";

  private Win32ElevationTarget() {
  }

  public static void mainDelegate(String updateKey) throws FileNotFoundException {
    File tmpDir = getRequiredFileSysProp(UPDATE_TEMP_DIR);
    PrintStream redirect = new PrintStream(new File(tmpDir, WIN_ELEV_LOG_FILE_NAME));
    System.setErr(redirect);
    System.setOut(redirect);
    try {
      UpdateContext ctx = new UpdateContext(
            getRequiredStringSysProp(UPDATE_APP_NAME),
            getRequiredFileSysProp(UPDATE_INSTALL_ROOT_DIR),
            getRequiredStringSysProp(UPDATE_OLD_VERSION),
            getRequiredFileSysProp(UPDATE_TEMP_DIR),
            getRequiredStringSysProp(UPDATE_NEW_VERSION)
            );
      if (updateKey.equals(WIN_ELEV_VALUE_RUN)) {
        new Win32UpdateCommitter(null, ctx).commit();
      }
      else if (updateKey.equals(WIN_ELEV_VALUE_TEST)) {
        new TestWin32UpdateCommitter(null, ctx).commit();
      }
      System.out.println(WIN_ELEV_SUCCESS_TOKEN);
    }
    catch (Throwable t) {
      t.printStackTrace();
    }
    finally {
      try {
        redirect.flush();
        redirect.close();
      }
      catch (Throwable t) {
        //nop
      }
    }
  }

  private static File getRequiredFileSysProp(String name) {
    String p = System.getProperty(name, "").replace("%20", " ").trim();
    if (p.length() == 0) {
      throw new IllegalArgumentException("system property " + name + " is required");
    }
    return new File(p);
  }

  private static String getRequiredStringSysProp(String name) {
    String p = System.getProperty(name, "").trim();
    if (p.length() == 0) {
      throw new IllegalArgumentException("system property " + name + " is required");
    }
    return p;
  }

}
