/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2;

import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.f2.resource.Texts;
import org.osgi.framework.BundleContext;

/**
 * The eclipse user agent reads os and arch from its profile and the application name and updatesite from the
 * configuration (config.ini, launch.ini, sys-properties)
 * via {@link BundleContext#getProperty(String)}.
 * <p>
 * Example properties of config.ini
 * <ul>
 * <li>f2.url=http://.../updatesite</li>
 * <li>f2.name=example</li>
 * <li>f2.http.user=xyz</li>
 * <li>f2.http.pass=xyz</li>
 * </ul>
 */
public class EclipseUserAgent extends BasicUserAgent {
  private final IProgressMonitor m_monitor;

  public EclipseUserAgent(IProgressMonitor monitor, Map<F2Parameter, String> optionMap) {
    super(optionMap);
    m_monitor = monitor;
    if (m_monitor != null) {
      m_monitor.beginTask(Texts.Updating, 100);
    }
  }

  @Override
  public void setProgressText(String name) {
    if (m_monitor == null) {
      return;
    }
    m_monitor.setTaskName(name);
  }

  @Override
  protected void updateProgress(int worked) {
    if (m_monitor == null) {
      return;
    }
    m_monitor.worked(worked);
  }
}
