/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal.update;

import java.io.File;

public class UpdateContext {
  private final String m_appName;
  private final File m_installRootDir;
  private final String m_oldVersion;
  private final File m_tmpDir;
  private final String m_newVersion;

  public UpdateContext(String appName, File installRootDir, String oldVersion, File tmpDir, String newVersion) {
    m_appName = appName;
    m_installRootDir = installRootDir;
    m_oldVersion = oldVersion;
    m_tmpDir = tmpDir;
    m_newVersion = newVersion;
  }

  public File getTempDir() {
    return m_tmpDir;
  }

  public String getOldVersion() {
    return m_oldVersion;
  }

  public String getNewVersion() {
    return m_newVersion;
  }

  public String getAppName() {
    return m_appName;
  }

  /**
   * The installation root containing one or more installation sub directories
   */
  public File getInstallRootDir() {
    return m_installRootDir;
  }

}
