/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal.create;

import java.util.Map;

import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.internal.create.linux.LinuxCreateProcessor;
import org.eclipse.update.f2.internal.create.macosx.MacosxCreateProcessor;
import org.eclipse.update.f2.internal.create.win32.Win32CreateProcessor;

public final class CreateProcessorFactory {

  private CreateProcessorFactory() {
  }

  /**
   * @param siteSubDir
   * @param os
   * @param arch
   * @param appName
   * @param tmpRoot
   */
  public static ICreateProcessor getProcessor(Map<F2Parameter, String> argMap) {
    String os = argMap.get(F2Parameter.OS);
    if (os.equals("win32")) {
      return new Win32CreateProcessor(argMap);
    }
    if (os.equals("macosx")) {
      return new MacosxCreateProcessor(argMap);
    }
    if (os.equals("linux")) {
      return new LinuxCreateProcessor(argMap);
    }
    //default
    return new Win32CreateProcessor(argMap);
  }
}
