/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2;

import java.util.concurrent.atomic.AtomicReference;

import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public interface IUserAgent {

  void preAuthenticate(AtomicReference<String> authMethod, NameCallback cbName, PasswordCallback cbPass);

  void authenticate(AtomicReference<String> authMethod, NameCallback cbName, PasswordCallback cbPass);

  void setProgressText(String name);

  /**
   * value is between 0.0 and 1.0
   */
  void setProgressValue(double value);
}
