/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.util.Base64Utility;
import org.eclipse.update.f2.internal.util.IStreamingListener;
import org.eclipse.update.f2.internal.util.LogUtility;
import org.eclipse.update.f2.internal.util.PathUtility;

public class FileUtility {
    public static final long DEFAULT_COMPRESSION_RATIO = 3L;

    private FileUtility() {
    }

    public static void mkdirs(File dir) {
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
    }

    public static boolean rmdir(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                if (files[i].isDirectory()) {
                    FileUtility.rmdir(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        File f = File.createTempFile(prefix, suffix);
        f.delete();
        f.mkdirs();
        return f;
    }

    public static byte[] readContent(long size, InputStream in, boolean closeInputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileUtility.streamContent(size, in, closeInputStream, out, true, null);
        return out.toByteArray();
    }

    public static void writeContent(OutputStream out, boolean closeOutputStream, byte[] content, IStreamingListener listener) throws IOException {
        FileUtility.streamContent(content.length, new ByteArrayInputStream(content), true, out, closeOutputStream, listener);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long streamContent(long size, InputStream in, boolean closeInputStream, OutputStream out, boolean closeOutputStream, IStreamingListener listener) throws IOException {
        try {
            block28: {
                if (size == 0L) {
                    return 0L;
                }
                if (size <= 0L) break block28;
                consumed = 0;
                buffer = new byte[8192];
                ** GOTO lbl18
            }
            buffer = new byte[8192];
            size = 0L;
            if (true) ** GOTO lbl24
            while ((n = in.read(buffer, 0, Math.min(buffer.length, (int)(size - (long)consumed)))) >= 0) {
                if (n > 0) {
                    out.write(buffer, 0, n);
                }
                consumed += n;
                if (listener != null) {
                    listener.streamed(n);
                }
lbl18:
                // 4 sources

                if ((long)consumed < size) continue;
            }
            var11_19 = size;
            return var11_19;
            do {
                out.write(buffer, 0, n);
                size += (long)n;
lbl24:
                // 2 sources

            } while ((n = in.read(buffer)) > 0);
            var11_20 = size;
            return var11_20;
        }
        finally {
            if (closeInputStream) {
                try {
                    in.close();
                }
                catch (Throwable var13_6) {}
            }
            if (closeOutputStream) {
                try {
                    out.close();
                }
                catch (Throwable var13_7) {}
            }
        }
    }

    public static void download(URL source, OutputStream out, long size, IUserAgent ua, IStreamingListener listener) throws IOException {
        LogUtility.info("Downloading " + source);
        BufferedInputStream is = null;
        URLConnection conn = null;
        int tryCount = 3;
        NameCallback cbName = new NameCallback("Username");
        PasswordCallback cbPass = new PasswordCallback("Password", false);
        AtomicReference<String> authMethodRef = new AtomicReference<String>("BASIC");
        ua.preAuthenticate(authMethodRef, cbName, cbPass);
        int i = 1;
        while (i <= tryCount && is == null) {
            try {
                conn = source.openConnection();
                if (cbName.getName() != null && cbPass.getPassword() != null) {
                    conn.setRequestProperty("Authorization", String.valueOf(authMethodRef.get()) + " " + Base64Utility.encode((String.valueOf(cbName.getName()) + ":" + new String(cbPass.getPassword())).getBytes("UTF-8")));
                }
                is = new BufferedInputStream(conn.getInputStream());
            }
            catch (IOException e) {
                LogUtility.warn("Downloading " + source + " failed " + i + " of " + tryCount, null);
                if (i == tryCount) {
                    throw e;
                }
                if (conn != null && conn instanceof HttpURLConnection && ((HttpURLConnection)conn).getResponseCode() == 401) {
                    String[] a;
                    String www = conn.getHeaderField("WWW-Authenticate");
                    if (www != null && (a = www.split(" ", 2))[0].length() > 0) {
                        authMethodRef.set(a[0]);
                    }
                    ua.authenticate(authMethodRef, cbName, cbPass);
                }
                throw e;
            }
            ++i;
        }
        FileUtility.streamContent(size, is, true, out, true, listener);
    }

    public static void compressArchive(File srcDir, String pathPrefix, File archiveFile, int deflaterLevel) throws Exception {
        if (pathPrefix.length() > 0 && !pathPrefix.endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix must be empty or end with a /");
        }
        ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(archiveFile));
        try {
            zOut.setLevel(deflaterLevel);
            archiveFile.delete();
            File[] fileArray = srcDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtility.addFileToZip(pathPrefix, f, zOut);
                ++n2;
            }
        }
        finally {
            try {
                zOut.finish();
            }
            catch (Throwable throwable) {}
            try {
                zOut.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void addFileToZip(String pathPrefix, File f, ZipOutputStream zOut) throws Exception {
        if (f.exists() && !f.isHidden() && !f.getName().startsWith(".svn")) {
            if (f.isDirectory()) {
                String path = String.valueOf(pathPrefix) + f.getName() + "/";
                FileUtility.addZipEntry(zOut, path, null);
                FileUtility.addFolderToZip(path, f, zOut);
            } else {
                String path = String.valueOf(pathPrefix) + f.getName();
                byte[] data = FileUtility.readContent(f.length(), new FileInputStream(f), true);
                FileUtility.addZipEntry(zOut, path, data);
            }
        }
    }

    private static void addFolderToZip(String pathPrefix, File dir, ZipOutputStream zOut) throws Exception {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("source directory " + dir + " does not exist or is not a folder");
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            FileUtility.addFileToZip(pathPrefix, f, zOut);
            ++n2;
        }
    }

    private static void addZipEntry(ZipOutputStream zOut, String path, byte[] data) throws Exception {
        zOut.putNextEntry(new ZipEntry(path));
        if (data != null) {
            zOut.write(data);
        }
        zOut.closeEntry();
    }

    public static void extractArchiveRoot(File archiveFile, File destinationDir, Set<String> pathsToIgnoreExtractErrors, IStreamingListener listener) throws IOException {
        FileUtility.mkdirs(destinationDir);
        ZipFile zip = new ZipFile(archiveFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String path = ze.getName();
                if (ze.isDirectory() || path.indexOf(47) >= 0) continue;
                File f = new File(destinationDir, path);
                if (pathsToIgnoreExtractErrors != null && pathsToIgnoreExtractErrors.contains(path)) {
                    try {
                        FileUtility.streamContent(ze.getSize(), zip.getInputStream(ze), true, new FileOutputStream(f), true, listener);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                FileUtility.streamContent(ze.getSize(), zip.getInputStream(ze), true, new FileOutputStream(f), true, listener);
            }
        }
        finally {
            try {
                zip.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void extractArchiveSubTree(File archiveFile, File destinationDir, Set<String> pathsToIgnoreExtractErrors, IStreamingListener listener) throws IOException {
        FileUtility.mkdirs(destinationDir);
        ZipFile zip = new ZipFile(archiveFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String path = ze.getName();
                if (path.indexOf(47) < 0) continue;
                File f = new File(destinationDir, path);
                if (ze.isDirectory()) {
                    FileUtility.mkdirs(f);
                    continue;
                }
                FileUtility.mkdirs(f.getParentFile());
                if (pathsToIgnoreExtractErrors != null && pathsToIgnoreExtractErrors.contains(path)) {
                    try {
                        FileUtility.streamContent(ze.getSize(), zip.getInputStream(ze), true, new FileOutputStream(f), true, listener);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                FileUtility.streamContent(ze.getSize(), zip.getInputStream(ze), true, new FileOutputStream(f), true, listener);
            }
        }
        finally {
            try {
                zip.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static boolean archiveEquals(InputStream archive1, boolean closeArchive1, InputStream archive2, boolean closeArchive2) throws IOException {
        return FileUtility.archiveHash(archive1, closeArchive1) == FileUtility.archiveHash(archive2, closeArchive2);
    }

    public static long archiveHash(File f) throws IOException {
        return FileUtility.archiveHash(new FileInputStream(f), true);
    }

    public static long archiveHash(InputStream archive, boolean closeArchive) throws IOException {
        TreeMap<String, long[]> sortMap = FileUtility.getSortedContentMap(archive, closeArchive);
        CRC32 crc = new CRC32();
        for (Map.Entry<String, long[]> e : sortMap.entrySet()) {
            crc.update(e.getKey().getBytes("UTF-8"));
            long n = e.getValue()[0];
            int i = 0;
            while (i < 8) {
                crc.update((int)(n & 0xFFL));
                n >>>= 8;
                ++i;
            }
            n = e.getValue()[1];
            i = 0;
            while (i < 8) {
                crc.update((int)(n & 0xFFL));
                n >>>= 8;
                ++i;
            }
        }
        return crc.getValue();
    }

    public static Set<String> archiveCompare(InputStream archive1, boolean closeArchive1, InputStream archive2, boolean closeArchive2) throws IOException {
        String name;
        TreeMap<String, long[]> map1 = FileUtility.getSortedContentMap(archive1, closeArchive1);
        TreeMap<String, long[]> map2 = FileUtility.getSortedContentMap(archive2, closeArchive2);
        TreeSet<String> deltaSet = new TreeSet<String>();
        for (Map.Entry<String, long[]> e : map1.entrySet()) {
            name = e.getKey();
            long[] z1 = e.getValue();
            long[] z2 = map2.get(name);
            if (z2 == null) {
                deltaSet.add("Left only: " + name + "\t" + z1[0] + "\t" + z1[1] + "\t0\t0");
                continue;
            }
            if (z1[0] == z2[0] && z1[1] == z2[1]) continue;
            deltaSet.add("Different: " + name + "\t" + z1[0] + "\t" + z1[1] + "\t" + z2[0] + "\t" + z2[1]);
        }
        for (Map.Entry<String, long[]> e : map2.entrySet()) {
            name = e.getKey();
            long[] z2 = e.getValue();
            long[] z1 = map1.get(name);
            if (z1 != null) continue;
            deltaSet.add("Right only:" + name + "\t0\t0" + "\t" + z2[0] + "\t" + z2[1]);
        }
        return deltaSet;
    }

    private static TreeMap<String, long[]> getSortedContentMap(InputStream in, boolean closeInputStream) throws IOException {
        final TreeMap<String, long[]> sortMap = new TreeMap<String, long[]>();
        FileUtility.visitArchiveContentRec("", new ZipInputStream(in), closeInputStream, new IZipVisitor(){

            @Override
            public void visit(ZipInputStream zin, String pathPrefix, ZipEntry e) throws IOException {
                if (!e.isDirectory()) {
                    sortMap.put(String.valueOf(pathPrefix) + e.getName(), FileUtility.sizeAndCrc32(zin, e));
                }
            }
        });
        return sortMap;
    }

    private static void visitArchiveContentRec(String pathPrefix, ZipInputStream zin, boolean closeInputStream, IZipVisitor visitor) throws IOException {
        try {
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                if (PathUtility.isArchiveEntry(ze)) {
                    ZipInputStream zinInner = new ZipInputStream(zin);
                    FileUtility.visitArchiveContentRec(String.valueOf(pathPrefix) + ze.getName() + "/", zinInner, false, visitor);
                } else {
                    visitor.visit(zin, pathPrefix, ze);
                }
                zin.closeEntry();
            }
        }
        finally {
            if (closeInputStream) {
                zin.close();
            }
        }
    }

    public static void copyFile(File source, File dest, IStreamingListener listener) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException(source.getAbsolutePath());
        }
        if (!source.canRead()) {
            throw new IOException("cannot read " + source);
        }
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException("cannot write " + dest);
        }
        if (source.isDirectory()) {
            throw new IOException("source is a directory: " + source);
        }
        if (dest.isDirectory()) {
            throw new IOException("destination is a directory: " + dest);
        }
        FileUtility.streamContent(source.length(), new FileInputStream(source), true, new FileOutputStream(dest), true, listener);
    }

    public static String sha1Base64(byte[] bytes) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(bytes, 0, bytes.length);
        return Base64Utility.encode(md.digest());
    }

    public static boolean isMatchingSizeAndCrc(File f, long size, long crc) throws IOException {
        return f.exists() && !f.isDirectory() && f.length() == size && FileUtility.crc32(f) == crc;
    }

    public static boolean isMatchingSizeAndCrc(ZipEntry z1, ZipEntry z2) {
        return z1.getCrc() == z2.getCrc() && z1.getSize() == z2.getSize();
    }

    public static boolean isMatchingSizeAndCrc(File f1, File f2) throws IOException {
        if (!f1.exists()) {
            return false;
        }
        if (!f2.exists()) {
            return false;
        }
        if (f1.length() != f2.length()) {
            return false;
        }
        return FileUtility.crc32(f1) == FileUtility.crc32(f2);
    }

    public static long crc32(File f) throws IOException {
        if (!f.exists()) {
            return 0L;
        }
        return FileUtility.sizeAndCrc32(f.length(), new FileInputStream(f), true)[1];
    }

    private static long[] sizeAndCrc32(ZipInputStream zin, ZipEntry e) throws IOException {
        long[] a = new long[]{e.getSize(), e.getCrc()};
        if (a[0] != -1L && a[1] != -1L) {
            return a;
        }
        a = FileUtility.sizeAndCrc32(e.getSize(), zin, false);
        if (e.getSize() != -1L) {
            a[0] = e.getSize();
        }
        if (e.getCrc() != -1L) {
            a[1] = e.getCrc();
        }
        return a;
    }

    public static long[] sizeAndCrc32(long size, InputStream in, boolean closeInputStream) throws IOException {
        final CRC32 crc = new CRC32();
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                crc.update(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                crc.update(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                crc.update(b, off, len);
            }
        };
        long sizeStreamed = FileUtility.streamContent(size, in, closeInputStream, out, true, null);
        return new long[]{size >= 0L ? size : sizeStreamed, crc.getValue()};
    }

    private static interface IZipVisitor {
        public void visit(ZipInputStream var1, String var2, ZipEntry var3) throws IOException;
    }
}

