/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.update.win32;

import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.update.AbstractUpdateProcessor;
import org.eclipse.update.f2.internal.update.ProgressPhase;
import org.eclipse.update.f2.internal.update.ProgressPhaseStreamingListener;
import org.eclipse.update.f2.internal.update.UpdateContext;
import org.eclipse.update.f2.internal.update.win32.Win32UpdateCommitter;
import org.eclipse.update.f2.internal.update.win32.elev.Win32ElevationCaller;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.LogUtility;

public class Win32UpdateProcessor
extends AbstractUpdateProcessor {
    public Win32UpdateProcessor(IUserAgent ua, Map<F2Parameter, String> optionMap) {
        super(ua, optionMap);
    }

    @Override
    protected void commit(UpdateContext ctx) throws Throwable {
        boolean containsUpdateExe = false;
        File archiveFile = new File(ctx.getTempDir(), String.valueOf(ctx.getNewVersion()) + ".zip");
        ZipFile z = new ZipFile(archiveFile);
        try {
            containsUpdateExe = z.getEntry(String.valueOf(ctx.getNewVersion()) + "/update.exe") != null;
        }
        finally {
            z.close();
        }
        String uacOption = this.getOptionMap().get((Object)F2Parameter.WindowsUAC);
        boolean useUAC = uacOption != null ? "true".equals(uacOption) : containsUpdateExe;
        LogUtility.info("Use admin elevation (UAC): " + useUAC);
        if (useUAC) {
            File exDir = new File(ctx.getTempDir(), "ex");
            FileUtility.mkdirs(exDir);
            ProgressPhaseStreamingListener extractListener = new ProgressPhaseStreamingListener(this.getUserAgent(), ProgressPhase.CommitCopy, archiveFile.length() * 3L);
            LogUtility.info("Extracting zip for UAC delegate");
            FileUtility.extractArchiveSubTree(archiveFile, exDir, null, extractListener);
            FileUtility.extractArchiveRoot(archiveFile, exDir, null, null);
            AtomicBoolean callDone = new AtomicBoolean(false);
            LogUtility.info("Launch UAC delegate");
            try {
                this.emulateProgress(callDone);
                new Win32ElevationCaller().call(ctx, new File(exDir, ctx.getNewVersion()));
            }
            finally {
                callDone.set(true);
            }
        } else {
            LogUtility.info("HINT: Not using UAC admin elevation");
            new Win32UpdateCommitter(this.getUserAgent(), ctx).commit();
        }
    }

    private void emulateProgress(final AtomicBoolean callDone) {
        final IUserAgent ua = this.getUserAgent();
        if (ua == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                long t = 0L;
                while (!callDone.get()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    ua.setProgressValue(ProgressPhase.CommitExtract.getProgress(t += 500L, 20000.0));
                }
            }
        }.start();
    }
}

