/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.update;

import java.util.Map;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.update.IUpdateProcessor;
import org.eclipse.update.f2.internal.update.linux.LinuxUpdateProcessor;
import org.eclipse.update.f2.internal.update.macosx.MacosxUpdateProcessor;
import org.eclipse.update.f2.internal.update.win32.Win32UpdateProcessor;

public final class UpdateProcessorFactory {
    private UpdateProcessorFactory() {
    }

    public static IUpdateProcessor getProcessor(IUserAgent ua, Map<F2Parameter, String> optionMap) {
        String os = optionMap.get((Object)F2Parameter.OS);
        if ("win32".equals(os)) {
            return new Win32UpdateProcessor(ua, optionMap);
        }
        if ("macosx".equals(os)) {
            return new MacosxUpdateProcessor(ua, optionMap);
        }
        if ("linux".equals(os)) {
            return new LinuxUpdateProcessor(ua, optionMap);
        }
        return new Win32UpdateProcessor(ua, optionMap);
    }
}

