/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.update.IUpdateCommitter;
import org.eclipse.update.f2.internal.update.ProgressPhase;
import org.eclipse.update.f2.internal.update.ProgressPhaseStreamingListener;
import org.eclipse.update.f2.internal.update.UpdateContext;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.LogUtility;
import org.eclipse.update.f2.internal.util.PathUtility;

public class DefaultUpdateCommitter
implements IUpdateCommitter {
    protected final IUserAgent m_ua;
    protected final UpdateContext m_ctx;

    public DefaultUpdateCommitter(IUserAgent ua, UpdateContext ctx) {
        this.m_ua = ua;
        this.m_ctx = ctx;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void commit() throws Throwable {
        block16: {
            block15: {
                srcZip = new File(this.m_ctx.getTempDir(), String.valueOf(this.m_ctx.getNewVersion()) + ".zip");
                dstZip = new File(this.m_ctx.getInstallRootDir(), String.valueOf(this.m_ctx.getNewVersion()) + ".zip");
                dstZipTemporary = new File(this.m_ctx.getInstallRootDir(), "tmp-" + this.m_ctx.getNewVersion() + ".zip");
                DefaultUpdateCommitter.checkExist(srcZip);
                DefaultUpdateCommitter.checkExist(this.m_ctx.getInstallRootDir());
                lockFile = new File(String.valueOf(dstZip.getAbsolutePath()) + ".lock");
                lockOut = new FileOutputStream(lockFile);
                lock = lockOut.getChannel().lock();
                backupFiles = new HashMap<File, File>();
                if (!dstZip.exists()) break block15;
                lock.release();
                lockOut.close();
                return;
            }
            try {
                try {
                    LogUtility.info("Copy candidate zip to installation folder " + dstZipTemporary);
                    dstZipTemporary.delete();
                    FileUtility.rmdir(new File(this.m_ctx.getInstallRootDir(), this.m_ctx.getNewVersion()));
                    copyListener = new ProgressPhaseStreamingListener(this.m_ua, ProgressPhase.CommitCopy, srcZip.length());
                    FileUtility.copyFile(srcZip, dstZipTemporary, copyListener);
                    if (!FileUtility.isMatchingSizeAndCrc(srcZip, dstZipTemporary)) {
                        throw new IOException("size/crc mismatch after copying " + srcZip + " to " + dstZipTemporary);
                    }
                    LogUtility.info("Extract zip");
                    extractListener = new ProgressPhaseStreamingListener(this.m_ua, ProgressPhase.CommitExtract, srcZip.length() * 3L);
                    FileUtility.extractArchiveSubTree(dstZipTemporary, this.m_ctx.getInstallRootDir(), this.getPathsToIgnoreExtractErrors(), extractListener);
                    var13_12 = this.m_ctx.getInstallRootDir().listFiles();
                    var12_14 = var13_12.length;
                    var11_17 = 0;
                    while (var11_17 < var12_14) {
                        f = var13_12[var11_17];
                        if (this.acceptTopLevelBackup(f)) {
                            bak = new File(String.valueOf(f.getAbsolutePath()) + ".bak");
                            backupFiles.put(f, bak);
                            FileUtility.copyFile(f, bak, null);
                        }
                        ++var11_17;
                    }
                    FileUtility.extractArchiveRoot(dstZipTemporary, this.m_ctx.getInstallRootDir(), this.getPathsToIgnoreExtractErrors(), null);
                    for (Map.Entry<K, V> be : backupFiles.entrySet()) {
                        bak = (File)be.getValue();
                        if (!bak.exists()) continue;
                        bak.delete();
                    }
                    dstZipTemporary.renameTo(dstZip);
                    this.removeOldVersions();
                    break block16;
                }
                catch (Throwable t) {
                    ** for (be : backupFiles.entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    f = (File)be.getKey();
                    bak = (File)be.getValue();
                    if (!bak.exists()) continue;
                    try {
                        try {
                            FileUtility.copyFile(bak, f, null);
                        }
                        catch (Throwable var13_13) {
                            bak.delete();
                            continue;
                        }
                    }
                    catch (Throwable var14_23) {
                        bak.delete();
                        throw var14_23;
                    }
                    bak.delete();
                    continue;
                }
lbl74:
                // 1 sources

                dstZipTemporary.delete();
                FileUtility.rmdir(new File(this.m_ctx.getInstallRootDir(), this.m_ctx.getNewVersion()));
                throw t;
            }
            catch (Throwable var15_24) {
                throw var15_24;
            }
            finally {
                lock.release();
                lockOut.close();
            }
        }
    }

    protected boolean acceptTopLevelBackup(File f) {
        if (f.isHidden()) {
            return false;
        }
        if (f.isDirectory()) {
            return false;
        }
        if (f.isHidden()) {
            return false;
        }
        if (f.getName().endsWith(".lock")) {
            return false;
        }
        return !f.getName().endsWith(".zip");
    }

    protected void removeOldVersions() {
        File[] fileArray = this.m_ctx.getInstallRootDir().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isHidden()) {
                if (f.isDirectory()) {
                    String directoryName = f.getName();
                    if (!directoryName.equalsIgnoreCase(this.m_ctx.getOldVersion()) && !directoryName.equalsIgnoreCase(this.m_ctx.getNewVersion()) && !f.equals(this.m_ctx.getTempDir()) && PathUtility.isValidF2DirectoryName(directoryName, this.m_ctx.getAppName())) {
                        FileUtility.rmdir(f);
                    }
                } else {
                    String filename = f.getName();
                    if (!(filename.equalsIgnoreCase(String.valueOf(this.m_ctx.getOldVersion()) + ".zip") || filename.equalsIgnoreCase(String.valueOf(this.m_ctx.getOldVersion()) + ".zip.lock") || filename.equalsIgnoreCase(String.valueOf(this.m_ctx.getNewVersion()) + ".zip") || filename.equalsIgnoreCase(String.valueOf(this.m_ctx.getNewVersion()) + ".zip.lock"))) {
                        String filenameWithoutExtension = filename;
                        if (filename.toLowerCase().endsWith(".zip.lock")) {
                            filenameWithoutExtension = filename.substring(0, filename.length() - ".zip.lock".length());
                        } else {
                            int pIndex = filename.lastIndexOf(46);
                            if (pIndex > 0) {
                                filenameWithoutExtension = filename.substring(0, pIndex);
                            }
                        }
                        if (PathUtility.isValidF2DirectoryName(filenameWithoutExtension, this.m_ctx.getAppName())) {
                            f.delete();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    protected Set<String> getPathsToIgnoreExtractErrors() {
        return null;
    }

    private static void checkExist(File f) throws IOException {
        if (!f.exists()) {
            throw new IOException(f + " does not exist");
        }
    }
}

