/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.update;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.UpdateResult;
import org.eclipse.update.f2.UpdateStrategy;
import org.eclipse.update.f2.internal.DeltaDesc;
import org.eclipse.update.f2.internal.SiteDesc;
import org.eclipse.update.f2.internal.Version3Q;
import org.eclipse.update.f2.internal.VersionDesc;
import org.eclipse.update.f2.internal.update.DefaultUpdateCommitter;
import org.eclipse.update.f2.internal.update.IUpdateProcessor;
import org.eclipse.update.f2.internal.update.ProgressPhase;
import org.eclipse.update.f2.internal.update.ProgressPhaseStreamingListener;
import org.eclipse.update.f2.internal.update.UpdateContext;
import org.eclipse.update.f2.internal.update.ZipDeltaUpdater;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.IStreamingListener;
import org.eclipse.update.f2.internal.util.LogUtility;

public abstract class AbstractUpdateProcessor
implements IUpdateProcessor {
    private final Map<F2Parameter, String> m_optionMap;
    private final IUserAgent m_ua;
    private final File m_installRootDir;
    private final File m_tmpDir;
    private final URL m_rawUrl;
    private URL m_targetUrl;

    public AbstractUpdateProcessor(IUserAgent ua, Map<F2Parameter, String> argMap) {
        HashMap hashMap = this.m_optionMap = argMap != null ? argMap : new HashMap();
        if (ua == null) {
            throw new IllegalArgumentException("user agent is null");
        }
        this.m_ua = ua;
        String siteUrl = this.m_optionMap.get((Object)F2Parameter.SiteUrl);
        try {
            this.m_rawUrl = new URL(siteUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException((Object)((Object)F2Parameter.SiteUrl) + " <" + siteUrl + "> is not valid: " + e);
        }
        String appName = this.m_optionMap.get((Object)F2Parameter.Name);
        if (appName == null) {
            throw new IllegalArgumentException((Object)((Object)F2Parameter.Name) + " is null");
        }
        String installArg = this.m_optionMap.get((Object)F2Parameter.InstallDirectory);
        if (installArg == null) {
            throw new IllegalArgumentException((Object)((Object)F2Parameter.InstallDirectory) + " is null");
        }
        this.m_installRootDir = new File(installArg);
        if (!this.m_installRootDir.exists()) {
            throw new IllegalArgumentException(this.m_installRootDir + " does not exist");
        }
        String tmpArg = this.m_optionMap.get((Object)F2Parameter.TempDirectory);
        this.m_tmpDir = tmpArg != null ? new File(tmpArg) : new File(this.m_installRootDir, "_tmp");
    }

    protected final IUserAgent getUserAgent() {
        return this.m_ua;
    }

    protected final Map<F2Parameter, String> getOptionMap() {
        return this.m_optionMap;
    }

    protected final File getInstallRootDir() {
        return this.m_installRootDir;
    }

    protected final File getTmpDir() {
        return this.m_tmpDir;
    }

    @Override
    public final UpdateResult update(UpdateStrategy strategy) {
        try {
            UpdateResult res;
            FileUtility.rmdir(this.getTmpDir());
            this.getTmpDir().mkdirs();
            try {
                res = this.updateInternal(strategy);
            }
            catch (Throwable t) {
                LogUtility.error("Update failed", t);
                res = UpdateResult.UpdateFailed;
            }
            try {
                this.getUserAgent().setProgressValue(1.0);
                this.getUserAgent().setProgressText(res.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            UpdateResult updateResult = res;
            return updateResult;
        }
        finally {
            FileUtility.rmdir(this.getTmpDir());
        }
    }

    protected UpdateResult updateInternal(UpdateStrategy strategy) throws Throwable {
        String oldVersion;
        VersionDesc oldVersionDesc;
        SiteDesc siteDesc = this.downloadSiteDesc();
        String limitVersion = this.getOptionMap().get((Object)F2Parameter.LimitedVersion);
        String newVersion = siteDesc.getLatestVersion(limitVersion);
        LogUtility.info("Latest version is " + newVersion);
        if (newVersion == null) {
            if (limitVersion != null) {
                LogUtility.info("UnexpectedVersion since version " + limitVersion + " does not exist");
                return UpdateResult.UnexpectedVersion;
            }
            LogUtility.info("NothingToDo since there is no latest version");
            return UpdateResult.NothingToDo;
        }
        VersionDesc newVersionDesc = this.findVersionDesc(siteDesc, newVersion);
        if (newVersionDesc == null) {
            LogUtility.warn("There is no desc available for the new version " + newVersion + " (bad configuration?)", null);
            return UpdateResult.UpdateFailed;
        }
        File installRootDir = this.getInstallRootDir();
        LogUtility.info("Installation root directory is " + installRootDir);
        TreeMap<Version3Q, VersionDesc> installedVersions = new TreeMap<Version3Q, VersionDesc>();
        File[] fileArray = this.m_installRootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionDesc vd;
            File dir = fileArray[n2];
            if (!dir.isHidden() && dir.isDirectory() && (vd = this.findVersionDesc(siteDesc, dir.getName())) != null && new File(this.m_installRootDir, String.valueOf(vd.getVersion()) + ".zip").exists()) {
                installedVersions.put(vd.getVersion3Q(), vd);
            }
            ++n2;
        }
        if (installedVersions.size() == 0) {
            LogUtility.warn(this.m_installRootDir + " does not contain an existing installation; Assuming it is empty or contains a legacy application.", null);
            oldVersionDesc = null;
        } else {
            oldVersionDesc = (VersionDesc)installedVersions.lastEntry().getValue();
            LogUtility.info("Old version is " + oldVersionDesc.getVersion());
        }
        String string = oldVersion = oldVersionDesc != null ? oldVersionDesc.getVersion() : null;
        if (newVersion.equalsIgnoreCase(oldVersion)) {
            LogUtility.info("NothingToDo since version is up to date");
            return UpdateResult.NothingToDo;
        }
        File alreadyInstalledNewVersionZip = new File(installRootDir, String.valueOf(newVersion) + ".zip");
        if (alreadyInstalledNewVersionZip.exists()) {
            LogUtility.info("NothingToDo since another process updated already");
            return UpdateResult.NothingToDo;
        }
        if (this.isVersionInstalled(newVersionDesc)) {
            LogUtility.info("No old version description found, but install directory seems to be a valid F2 installation with the newest version.");
            return UpdateResult.NothingToDo;
        }
        if (strategy == UpdateStrategy.CheckForUpdate) {
            LogUtility.info("UpdateRequired");
            return UpdateResult.UpdateRequired;
        }
        UpdateContext ctx = new UpdateContext(this.m_optionMap.get((Object)F2Parameter.Name), installRootDir, oldVersion, this.m_tmpDir, newVersion);
        try {
            if (oldVersion != null) {
                File oldInstalledZip = new File(ctx.getInstallRootDir(), String.valueOf(ctx.getOldVersion()) + ".zip");
                LogUtility.info("Does old zip " + oldInstalledZip + " exist? " + oldInstalledZip.exists());
                if (oldInstalledZip.exists()) {
                    List<DeltaDesc> deltaList = this.calculateRequiredDeltas(siteDesc, ctx.getOldVersion(), ctx.getNewVersion());
                    if (oldVersionDesc != null && !deltaList.isEmpty() && this.getDownloadSizeOfDeltaList(deltaList) < newVersionDesc.getSize() * 8L / 10L) {
                        this.doDeltaUpdate(siteDesc, deltaList, oldVersionDesc, newVersionDesc, ctx);
                        LogUtility.info("UpdateSuccessful");
                        return UpdateResult.UpdateSuccessful;
                    }
                }
            }
        }
        catch (Throwable t) {
            LogUtility.warn("Delta update failed", t);
        }
        this.doFullUpdate(siteDesc, newVersionDesc, ctx);
        LogUtility.info("UpdateSuccessful");
        return UpdateResult.UpdateSuccessful;
    }

    protected boolean isVersionInstalled(VersionDesc versionDesc) {
        try {
            String path = this.m_optionMap.get((Object)F2Parameter.ApplicationRunningDirectory);
            if (path != null) {
                File installDir = new File(path);
                VersionDesc installedVersionDesc = new VersionDesc(installDir.getName(), 0L, 0L, 0L);
                return versionDesc.getVersion().equals(installedVersionDesc.getVersion());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected SiteDesc downloadSiteDesc() throws IOException {
        ProgressPhaseStreamingListener strListener = new ProgressPhaseStreamingListener(this.m_ua, ProgressPhase.DownloadSiteDesc, 1000L);
        String os = this.getOptionMap().get((Object)F2Parameter.OS);
        String arch = this.getOptionMap().get((Object)F2Parameter.Arch);
        if (arch != null) {
            this.m_targetUrl = new URL(this.m_rawUrl, String.valueOf(this.m_rawUrl.getPath()) + "/" + os + "/" + arch + "/");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.downloadImpl("f2.txt", bos, -1L, strListener);
                return SiteDesc.parse(new String(bos.toByteArray(), "UTF-8"));
            }
            catch (Throwable bos) {
                // empty catch block
            }
        }
        this.m_targetUrl = new URL(this.m_rawUrl, String.valueOf(this.m_rawUrl.getPath()) + "/" + os + "/");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.downloadImpl("f2.txt", bos, -1L, strListener);
        return SiteDesc.parse(new String(bos.toByteArray(), "UTF-8"));
    }

    protected void doDeltaUpdate(SiteDesc siteDesc, List<DeltaDesc> deltaList, VersionDesc oldVersionDesc, VersionDesc newVersionDesc, UpdateContext ctx) throws Throwable {
        LogUtility.info("Delta update");
        File oldInstalledZip = new File(ctx.getInstallRootDir(), String.valueOf(ctx.getOldVersion()) + ".zip");
        if (!oldInstalledZip.exists()) {
            throw new IOException("old zip " + oldInstalledZip + " does not exist");
        }
        boolean checkContentHash = "true".equals(this.getOptionMap().get((Object)F2Parameter.CheckContentHash));
        if (checkContentHash) {
            LogUtility.info("check content hash of old zip " + oldInstalledZip.getName());
            long h = FileUtility.archiveHash(oldInstalledZip);
            if (h != oldVersionDesc.getContentHash()) {
                throw new IOException("content hash mismatch on zipped old zip: expected " + oldVersionDesc.getContentHash() + " got " + h);
            }
        }
        ProgressPhaseStreamingListener downloadListener = new ProgressPhaseStreamingListener(this.m_ua, ProgressPhase.DownloadZipFiles, this.getDownloadSizeOfDeltaList(deltaList));
        boolean checkFileSize = "true".equals(this.getOptionMap().get((Object)F2Parameter.CheckFileSize));
        for (DeltaDesc desc : deltaList) {
            File deltaFile = new File(ctx.getTempDir(), desc.getFileName());
            this.downloadImpl(desc.getFileName(), new FileOutputStream(deltaFile), desc.getSize(), downloadListener);
            this.checkCrc(deltaFile, desc.getCrc());
            if (!checkFileSize) continue;
            this.checkFileSize(deltaFile, desc.getSize());
        }
        File inFile = oldInstalledZip;
        File outFile = null;
        ProgressPhaseStreamingListener applyListener = new ProgressPhaseStreamingListener(this.m_ua, ProgressPhase.BuildUpdate, newVersionDesc.getSize());
        for (DeltaDesc desc : deltaList) {
            File deltaFile = new File(ctx.getTempDir(), desc.getFileName());
            outFile = new File(ctx.getTempDir(), String.valueOf(desc.getNewVersion()) + ".zip");
            LogUtility.info("Delta update from " + desc.getOldVersion() + " to " + desc.getNewVersion() + " with " + desc.getSize() + " bytes");
            new ZipDeltaUpdater().process(inFile, deltaFile, outFile, ctx.getTempDir(), applyListener);
            inFile = outFile;
        }
        if (checkContentHash) {
            LogUtility.info("check content hash of new zip " + (outFile != null ? outFile.getName() : null));
            long expectedHash = newVersionDesc.getContentHash();
            long actualHash = FileUtility.archiveHash(outFile);
            if (expectedHash != actualHash) {
                throw new IOException("content hash mismatch on " + outFile + ": expected " + expectedHash + " got " + actualHash);
            }
        }
        LogUtility.info("Committing");
        this.commit(ctx);
    }

    protected void doFullUpdate(SiteDesc siteDesc, VersionDesc desc, UpdateContext ctx) throws Throwable {
        LogUtility.info("Full update");
        File vFile = new File(ctx.getTempDir(), desc.getFileName());
        ProgressPhaseStreamingListener downloadListener = new ProgressPhaseStreamingListener(this.m_ua, ProgressPhase.DownloadZipFiles, desc.getSize());
        this.downloadImpl(desc.getFileName(), new FileOutputStream(vFile), desc.getSize(), downloadListener);
        this.m_ua.setProgressValue(ProgressPhase.BuildUpdate.getProgress(1.0, 1.0));
        this.checkCrc(vFile, desc.getCrc());
        boolean checkFileSize = "true".equals(this.getOptionMap().get((Object)F2Parameter.CheckFileSize));
        if (checkFileSize) {
            this.checkFileSize(vFile, desc.getSize());
        }
        LogUtility.info("Committing");
        this.commit(ctx);
    }

    protected void commit(UpdateContext ctx) throws Throwable {
        new DefaultUpdateCommitter(this.m_ua, ctx).commit();
    }

    protected void downloadImpl(String context, OutputStream out, long size, IStreamingListener listener) throws IOException {
        URL url = new URL(this.m_targetUrl, context);
        FileUtility.download(url, out, size, this.m_ua, listener);
    }

    protected void checkCrc(File f, long expectedCrc) throws IOException {
        LogUtility.info("Check CRC of " + f.getName());
        long actualCrc = FileUtility.crc32(f);
        if (actualCrc != expectedCrc) {
            throw new IOException("crc mismatch on " + f.getName() + ": expected " + Long.toHexString(expectedCrc) + " got " + Long.toHexString(actualCrc));
        }
    }

    protected void checkFileSize(File f, long expectedSize) throws IOException {
        LogUtility.info("Check Size of " + f.getName());
        long actualSize = f.length();
        if (actualSize != expectedSize) {
            throw new IOException("Size mismatch on " + f.getName() + ": expected " + expectedSize + " got " + actualSize);
        }
    }

    protected List<DeltaDesc> calculateRequiredDeltas(SiteDesc siteDesc, String oldVersion, String newVersion) {
        TreeMap<Long, List<DeltaDesc>> candidates = new TreeMap<Long, List<DeltaDesc>>();
        ArrayList<DeltaDesc> currentList = new ArrayList<DeltaDesc>();
        for (DeltaDesc desc : siteDesc.getDeltaList()) {
            if (!desc.getOldVersion().equals(oldVersion)) continue;
            currentList.add(desc);
            this.visitDeltaList(siteDesc, currentList, candidates, newVersion);
            currentList.remove(desc);
        }
        if (candidates.size() == 0) {
            return Collections.emptyList();
        }
        return (List)candidates.get(candidates.firstKey());
    }

    protected void visitDeltaList(SiteDesc siteDesc, List<DeltaDesc> currentList, Map<Long, List<DeltaDesc>> candidates, String maxVersion) {
        String curVersion = currentList.get(currentList.size() - 1).getNewVersion();
        if (curVersion.equals(maxVersion)) {
            candidates.put(this.getDownloadSizeOfDeltaList(currentList), new ArrayList<DeltaDesc>(currentList));
            return;
        }
        for (DeltaDesc desc : siteDesc.getDeltaList()) {
            if (!desc.getOldVersion().equals(curVersion)) continue;
            currentList.add(desc);
            this.visitDeltaList(siteDesc, currentList, candidates, maxVersion);
            currentList.remove(desc);
        }
    }

    protected long getDownloadSizeOfDeltaList(List<DeltaDesc> list) {
        long size = 0L;
        for (DeltaDesc desc : list) {
            size += desc.getSize();
        }
        return size;
    }

    protected VersionDesc findVersionDesc(SiteDesc siteDesc, String version) {
        for (VersionDesc desc : siteDesc.getVersionList()) {
            if (!desc.getVersion().equals(version)) continue;
            return desc;
        }
        return null;
    }
}

