/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.create.win32;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.internal.create.AbstractCreateProcessor;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.LogUtility;
import org.eclipse.update.f2.internal.util.PathUtility;

public class Win32CreateProcessor
extends AbstractCreateProcessor {
    private static final Pattern JVM_DLL_PATH_PATTERN = Pattern.compile("((.*/)?jre.*/bin/client/jvm.dll)", 2);
    private static final Pattern JAVAW_EXE_PATH_PATTERN = Pattern.compile("((.*/)?jre.*/bin/javaw.exe)", 2);

    public Win32CreateProcessor(Map<F2Parameter, String> optionMap) {
        super(optionMap);
    }

    @Override
    protected void autoCompleteFullVersionZipStructure(File f, String versionFolderName) throws IOException {
        LogUtility.info("verifying content of " + f.getName());
        ZipFile z = new ZipFile(f);
        File t = new File(String.valueOf(f.getAbsolutePath()) + ".tmp");
        try {
            Pattern innerAppFilePattern = Pattern.compile("([^/]+)/([^/]+)\\.exe");
            boolean containsF2Plugin = false;
            HashSet<String> exeNames = new HashSet<String>();
            HashSet<String> rootEntryNames = new HashSet<String>();
            Enumeration<? extends ZipEntry> en = z.entries();
            while (en.hasMoreElements()) {
                Matcher m;
                ZipEntry ze = en.nextElement();
                String path = ze.getName();
                if (!path.contains("/")) {
                    rootEntryNames.add(path);
                }
                if (PathUtility.F2_JAR_PATH_PATTERN.matcher(path).matches()) {
                    containsF2Plugin = true;
                }
                if (!(m = innerAppFilePattern.matcher(path)).matches() || !m.group(1).equals(versionFolderName)) continue;
                exeNames.add(m.group(2));
            }
            exeNames.remove("update");
            if (exeNames.size() == 0) {
                throw new IOException("zip must contain at least one application exe");
            }
            String uacOption = this.getOptionMap().get((Object)F2Parameter.WindowsUAC);
            boolean useUAC = uacOption != null ? "true".equals(uacOption) : containsF2Plugin;
            boolean complete = true;
            String innerUpdateExePath = String.valueOf(versionFolderName) + "/update.exe";
            String innerUpdateIniPath = String.valueOf(versionFolderName) + "/update.ini";
            if (useUAC) {
                if (z.getEntry(innerUpdateExePath) == null) {
                    complete = false;
                }
                if (z.getEntry(innerUpdateIniPath) == null) {
                    complete = false;
                }
            }
            for (String exeName : exeNames) {
                if (!rootEntryNames.contains(String.valueOf(exeName) + ".exe")) {
                    complete = false;
                    break;
                }
                if (rootEntryNames.contains(String.valueOf(exeName) + ".ini")) continue;
                complete = false;
                break;
            }
            if (complete) {
                return;
            }
            ZipOutputStream zOut = new ZipOutputStream(new FileOutputStream(t));
            zOut.setLevel(9);
            try {
                String rootPath;
                Enumeration<? extends ZipEntry> en2 = z.entries();
                while (en2.hasMoreElements()) {
                    Iterator e = en2.nextElement();
                    zOut.putNextEntry(new ZipEntry(((ZipEntry)((Object)e)).getName()));
                    if (!((ZipEntry)((Object)e)).isDirectory()) {
                        FileUtility.streamContent(((ZipEntry)((Object)e)).getSize(), z.getInputStream((ZipEntry)((Object)e)), true, zOut, false, null);
                    }
                    zOut.closeEntry();
                }
                for (String exeName : exeNames) {
                    rootPath = String.valueOf(exeName) + ".exe";
                    if (z.getEntry(rootPath) != null) continue;
                    LogUtility.info(" adding " + rootPath);
                    ZipEntry innerExe = z.getEntry(String.valueOf(versionFolderName) + "/" + exeName + ".exe");
                    zOut.putNextEntry(new ZipEntry(rootPath));
                    FileUtility.streamContent(innerExe.getSize(), z.getInputStream(innerExe), true, zOut, false, null);
                    zOut.closeEntry();
                }
                for (String exeName : exeNames) {
                    rootPath = String.valueOf(exeName) + ".ini";
                    if (z.getEntry(rootPath) != null) continue;
                    LogUtility.info(" adding " + rootPath);
                    ZipEntry innerIni = z.getEntry(String.valueOf(versionFolderName) + "/" + exeName + ".ini");
                    zOut.putNextEntry(new ZipEntry(rootPath));
                    byte[] innerIniContent = null;
                    if (innerIni != null) {
                        innerIniContent = FileUtility.readContent(innerIni.getSize(), z.getInputStream(innerIni), true);
                    }
                    byte[] data = this.createRootAppIni(z, versionFolderName, innerIniContent);
                    zOut.write(data);
                    zOut.closeEntry();
                }
                if (useUAC) {
                    if (z.getEntry(innerUpdateExePath) == null) {
                        LogUtility.info(" adding " + innerUpdateExePath);
                        ZipEntry innerExe = z.getEntry(String.valueOf(versionFolderName) + "/" + (String)exeNames.iterator().next() + ".exe");
                        zOut.putNextEntry(new ZipEntry(innerUpdateExePath));
                        FileUtility.streamContent(innerExe.getSize(), z.getInputStream(innerExe), true, zOut, false, null);
                        zOut.closeEntry();
                    }
                    if (z.getEntry(innerUpdateIniPath) == null) {
                        LogUtility.info(" adding " + innerUpdateIniPath);
                        ZipEntry innerIni = z.getEntry(String.valueOf(versionFolderName) + "/" + (String)exeNames.iterator().next() + ".ini");
                        byte[] innerIniContent = null;
                        if (innerIni != null) {
                            innerIniContent = FileUtility.readContent(innerIni.getSize(), z.getInputStream(innerIni), true);
                        }
                        zOut.putNextEntry(new ZipEntry(innerUpdateIniPath));
                        byte[] data = this.createInnerUpdateIni(z, innerIniContent);
                        zOut.write(data);
                        zOut.closeEntry();
                    }
                }
            }
            finally {
                zOut.close();
            }
        }
        finally {
            z.close();
        }
        f.delete();
        t.renameTo(f);
    }

    protected byte[] createRootAppIni(ZipFile z, String versionFolderName, byte[] innerIni) throws IOException {
        String startupJar = null;
        String vmExe = null;
        String vmDll = null;
        String launcherLibrary = null;
        ArrayList<String> args = new ArrayList<String>();
        if (innerIni != null) {
            args.addAll(Arrays.asList(new String(innerIni, "UTF-8").split("\\s+")));
        }
        Enumeration<? extends ZipEntry> en = z.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            Matcher m = JVM_DLL_PATH_PATTERN.matcher(ze.getName());
            if (m.matches()) {
                vmDll = m.group(1);
                continue;
            }
            m = JAVAW_EXE_PATH_PATTERN.matcher(ze.getName());
            if (m.matches()) {
                vmExe = m.group(1);
                continue;
            }
            m = PathUtility.LAUNCHER_JAR_PATH_PATTERN.matcher(ze.getName());
            if (m.matches()) {
                startupJar = m.group(1);
                continue;
            }
            m = PathUtility.LAUNCHER_LIBRARY_PATH_PATTERN.matcher(ze.getName());
            if (!m.matches()) continue;
            launcherLibrary = m.group(1);
        }
        int i = 0;
        while (i < args.size()) {
            String[] parts;
            String s = (String)args.get(i);
            if ("--launcher.library".equals(s) || "-startup".equals(s) || "-vm".equals(s)) {
                args.set(++i, String.valueOf(versionFolderName) + File.separator + (String)args.get(i));
            } else if (s != null && s.startsWith("-Djava.util.logging.config.file=")) {
                parts = s.split("=", 2);
                if (parts.length > 1) {
                    args.set(i, String.valueOf(parts[0]) + "=" + versionFolderName + File.separator + parts[1]);
                }
            } else if (s != null && s.startsWith("-Dlog4j.configuration=file:") && (parts = s.split(":", 2)).length > 1) {
                args.set(i, String.valueOf(parts[0]) + ":" + versionFolderName + File.separator + parts[1]);
            }
            ++i;
        }
        if (!args.contains("-vm")) {
            if (vmDll == null && vmExe == null) {
                throw new IOException("could not find a jre in " + z.getName());
            }
            args.add(0, "-vm");
            args.add(1, vmDll != null ? vmDll : vmExe);
        }
        if (!args.contains("-startup")) {
            if (startupJar == null) {
                throw new IOException("could not find a startup jar in " + z.getName());
            }
            args.add(0, "-startup");
            args.add(1, startupJar);
        }
        if (!args.contains("--launcher.library")) {
            if (launcherLibrary == null) {
                throw new IOException("could not find a launcher.library in " + z.getName());
            }
            args.add(0, "--launcher.library");
            args.add(1, launcherLibrary);
        }
        StringBuilder buf = new StringBuilder();
        for (String s : args) {
            buf.append(s);
            buf.append("\n");
        }
        String rootIniContent = buf.toString().trim();
        return rootIniContent.getBytes("UTF-8");
    }

    protected byte[] createInnerUpdateIni(ZipFile z, byte[] innerIni) throws IOException {
        String startupJar = null;
        String vmExe = null;
        ArrayList<String> args = new ArrayList<String>();
        if (innerIni != null) {
            args.addAll(Arrays.asList(new String(innerIni, "UTF-8").split("\\s+")));
        }
        Enumeration<? extends ZipEntry> en = z.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            Matcher m = PathUtility.F2_JAR_PATH_PATTERN.matcher(ze.getName());
            if (m.matches()) {
                startupJar = PathUtility.splitFirstPart(m.group(1))[1];
                break;
            }
            m = JAVAW_EXE_PATH_PATTERN.matcher(ze.getName());
            if (!m.matches()) continue;
            vmExe = PathUtility.splitFirstPart(m.group(1))[1];
        }
        if (vmExe == null) {
            LogUtility.warn("There is no java runtime folder in " + z.getName(), null);
        }
        if (startupJar == null) {
            return null;
        }
        if (vmExe != null && !args.contains("-vm")) {
            args.add(0, "-vm");
            args.add(1, "XXX");
        }
        if (!args.contains("-startup")) {
            args.add(0, "-startup");
            args.add(1, "XXX");
        }
        int i = 0;
        while (i < args.size()) {
            String s = (String)args.get(i);
            if ("-startup".equals(s)) {
                args.set(++i, startupJar);
            } else if ("-vm".equals(s)) {
                args.set(++i, vmExe);
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        for (String s : args) {
            buf.append(s);
            buf.append("\n");
        }
        String updateIniContent = buf.toString().trim();
        return updateIniContent.getBytes("UTF-8");
    }
}

