/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.create;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.internal.DeltaDesc;
import org.eclipse.update.f2.internal.SiteDesc;
import org.eclipse.update.f2.internal.Version3Q;
import org.eclipse.update.f2.internal.VersionDesc;
import org.eclipse.update.f2.internal.create.ICreateProcessor;
import org.eclipse.update.f2.internal.create.ZipDeltaBuilder;
import org.eclipse.update.f2.internal.update.ZipDeltaUpdater;
import org.eclipse.update.f2.internal.util.FileUtility;
import org.eclipse.update.f2.internal.util.LogUtility;

public abstract class AbstractCreateProcessor
implements ICreateProcessor {
    protected final File m_siteDir;
    protected final String m_appName;
    private final File m_tmpDir;
    private Map<F2Parameter, String> m_optionMap;

    public AbstractCreateProcessor(Map<F2Parameter, String> argMap) {
        this.m_optionMap = argMap != null ? argMap : new HashMap();
        File siteRoot = new File(this.m_optionMap.get((Object)F2Parameter.SiteDirectory));
        String os = this.m_optionMap.get((Object)F2Parameter.OS);
        String arch = this.m_optionMap.get((Object)F2Parameter.Arch);
        this.m_siteDir = new File(siteRoot, String.valueOf(os) + (arch != null ? "/" + arch : ""));
        this.m_appName = this.m_optionMap.get((Object)F2Parameter.Name);
        String tmpArg = this.m_optionMap.get((Object)F2Parameter.TempDirectory);
        File file = this.m_tmpDir = tmpArg != null ? new File(tmpArg) : new File(this.m_siteDir, "_tmp");
        if (!this.m_siteDir.exists()) {
            throw new IllegalArgumentException("site directory does not exist: " + this.m_siteDir);
        }
        if (this.m_appName == null) {
            throw new IllegalArgumentException("name is null");
        }
    }

    protected final Map<F2Parameter, String> getOptionMap() {
        return this.m_optionMap;
    }

    protected final File getTmpDir() {
        return this.m_tmpDir;
    }

    @Override
    public final void create() throws Exception {
        try {
            FileUtility.rmdir(this.getTmpDir());
            this.getTmpDir().mkdirs();
            this.createInternal();
        }
        finally {
            FileUtility.rmdir(this.getTmpDir());
        }
    }

    protected void createInternal() throws Exception {
        Object versionDesc;
        boolean changed = false;
        SiteDesc desc = this.readExistingSiteDesc();
        HashSet<String> validVersionNames = new HashSet<String>();
        TreeMap<Version3Q, VersionDesc> allVersionDescMap = new TreeMap<Version3Q, VersionDesc>();
        File[] fileArray = this.m_siteDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block41: {
                File f = fileArray[n2];
                if (!f.isDirectory() && f.getName().endsWith(".zip")) {
                    String fname = f.getName();
                    if (this.isDeltaName(fname)) {
                        try {
                            DeltaDesc deltaDesc = new DeltaDesc(fname, 0L, 0L);
                            if (!deltaDesc.getOldVersion().startsWith(String.valueOf(this.m_appName) + "_")) {
                                throw new IllegalArgumentException("delta file name must contain the application name as prefixes (" + this.m_appName + ")");
                            }
                            if (!deltaDesc.getNewVersion().startsWith(String.valueOf(this.m_appName) + "_")) {
                                throw new IllegalArgumentException("delta file name must contain the application name as prefixes (" + this.m_appName + ")");
                            }
                        }
                        catch (Throwable t) {
                            LogUtility.warn(t + ". Renaming it to " + fname + ".err", null);
                            f.renameTo(new File(this.m_siteDir, String.valueOf(fname) + ".err"));
                        }
                    } else {
                        VersionDesc versionDesc2;
                        try {
                            versionDesc2 = new VersionDesc(fname, 0L, 0L, 0L);
                            if (!versionDesc2.getVersion().startsWith(String.valueOf(this.m_appName) + "_")) {
                                throw new IllegalArgumentException("version file name must contain the application name as prefix (" + this.m_appName + ")");
                            }
                        }
                        catch (Throwable t) {
                            LogUtility.warn(t + ". Renaming it to " + fname + ".err", null);
                            f.renameTo(new File(this.m_siteDir, String.valueOf(fname) + ".err"));
                            break block41;
                        }
                        if (!this.checkFullVersionZipStructure(f, String.valueOf(versionDesc2.getVersion()) + "/")) {
                            LogUtility.warn(String.valueOf(fname) + " is not a valid full-version zip, it does not have root folder '" + versionDesc2.getVersion() + "'. Renaming it to " + fname + ".err", null);
                            f.renameTo(new File(this.m_siteDir, String.valueOf(fname) + ".err"));
                        } else {
                            this.autoCompleteFullVersionZipStructure(f, versionDesc2.getVersion());
                            if (this.checkIntegrity(desc, f)) {
                                validVersionNames.add(versionDesc2.getVersion());
                            } else {
                                LogUtility.info(String.valueOf(fname) + " is not matching size/crc/content-hash of f2.txt. Invalidating it.");
                                changed = true;
                            }
                            allVersionDescMap.put(versionDesc2.getVersion3Q(), versionDesc2);
                        }
                    }
                }
            }
            ++n2;
        }
        String numberOfVersionsToKeepString = this.getOptionMap().get((Object)F2Parameter.NumberOfVersionsToKeep);
        if (numberOfVersionsToKeepString != null) {
            int numberOfVersionsToKeep = 0;
            try {
                numberOfVersionsToKeep = Integer.parseInt(numberOfVersionsToKeepString);
            }
            catch (NumberFormatException e) {
                LogUtility.warn("Failed to parse " + F2Parameter.NumberOfVersionsToKeep.name() + " parameter", e);
            }
            if (numberOfVersionsToKeep > 0) {
                int numberOfVersionsToRemove = allVersionDescMap.size() - numberOfVersionsToKeep;
                if (numberOfVersionsToRemove > 0) {
                    LogUtility.info("keeping " + numberOfVersionsToKeep + " out of " + allVersionDescMap.size() + " versions, thus removing the " + numberOfVersionsToRemove + " oldest ones.");
                    Iterator it = allVersionDescMap.values().iterator();
                    while (it.hasNext()) {
                        if (numberOfVersionsToRemove != 0) {
                            versionDesc = (VersionDesc)it.next();
                            if (!new File(this.m_siteDir, ((VersionDesc)versionDesc).getFileName()).delete()) {
                                LogUtility.warn("failed to remove old application version file " + ((VersionDesc)versionDesc).getFileName(), null);
                            } else {
                                LogUtility.info("successfully removed old application version file " + ((VersionDesc)versionDesc).getFileName());
                            }
                            validVersionNames.remove(((VersionDesc)versionDesc).getVersion());
                            it.remove();
                            --numberOfVersionsToRemove;
                            continue;
                        }
                        break;
                    }
                } else {
                    LogUtility.info("keeping maximum " + numberOfVersionsToKeep + " out of " + allVersionDescMap.size() + " versions, thus keeping all.");
                }
            }
        }
        versionDesc = this.m_siteDir.listFiles();
        int it = ((File[])versionDesc).length;
        int numberOfVersionsToRemove = 0;
        while (numberOfVersionsToRemove < it) {
            String fname;
            File f = versionDesc[numberOfVersionsToRemove];
            if (!f.isDirectory() && f.getName().endsWith(".zip") && this.isDeltaName(fname = f.getName())) {
                DeltaDesc deltaDesc = new DeltaDesc(fname, 0L, 0L);
                if (!validVersionNames.contains(deltaDesc.getOldVersion()) || !validVersionNames.contains(deltaDesc.getNewVersion())) {
                    LogUtility.info(String.valueOf(fname) + " is not referring to a valid version. Deleting it.");
                    f.delete();
                } else if (!this.checkIntegrity(desc, f)) {
                    LogUtility.info(String.valueOf(fname) + " is not up to date. Deleting it.");
                    f.delete();
                }
            }
            ++numberOfVersionsToRemove;
        }
        if (!changed) {
            for (VersionDesc exDesc : desc.getVersionList()) {
                if (new File(this.m_siteDir, exDesc.getFileName()).exists()) continue;
                changed = true;
                break;
            }
        }
        if (!changed) {
            for (DeltaDesc exDesc : desc.getDeltaList()) {
                if (new File(this.m_siteDir, exDesc.getFileName()).exists()) continue;
                changed = true;
                break;
            }
        }
        try {
            ArrayList allVersionDescList = new ArrayList(allVersionDescMap.values());
            int i = 0;
            while (i < allVersionDescList.size() - 1) {
                String v1 = ((VersionDesc)allVersionDescList.get(i)).getVersion();
                String v2 = ((VersionDesc)allVersionDescList.get(i + 1)).getVersion();
                String nameDelta = "delta$" + v1 + "$" + v2;
                File deltaFile = new File(this.m_siteDir, String.valueOf(nameDelta) + ".zip");
                if (deltaFile.exists()) {
                    LogUtility.info(String.valueOf(nameDelta) + " is up-to-date.");
                } else {
                    changed = true;
                    this.createDelta(v1, v2, nameDelta);
                    this.testDelta(v1, v2, nameDelta);
                }
                ++i;
            }
        }
        finally {
            FileUtility.rmdir(this.m_tmpDir);
        }
        if (changed) {
            LogUtility.info("Create f2.txt");
            this.createF2Txt();
        }
        LogUtility.info("Done");
    }

    private boolean isDeltaName(String name) {
        return name.startsWith("delta$");
    }

    private SiteDesc readExistingSiteDesc() {
        File f = new File(this.m_siteDir, "f2.txt");
        if (f.exists()) {
            try {
                return SiteDesc.parse(new String(FileUtility.readContent(f.length(), new FileInputStream(f), true), "UTF-8"));
            }
            catch (Throwable t) {
                LogUtility.info("Failed reading existing " + f.getName() + ": " + t);
            }
        }
        return null;
    }

    protected boolean checkFullVersionZipStructure(File f, String topLevelFolder) throws IOException {
        ZipFile z = new ZipFile(f);
        try {
            Enumeration<? extends ZipEntry> en = z.entries();
            while (en.hasMoreElements()) {
                String path;
                ZipEntry e = en.nextElement();
                if (!e.isDirectory() || (path = e.getName()).startsWith(topLevelFolder)) continue;
                return false;
            }
            return true;
        }
        finally {
            z.close();
        }
    }

    protected abstract void autoCompleteFullVersionZipStructure(File var1, String var2) throws IOException;

    private boolean checkIntegrity(SiteDesc siteDesc, File f) throws IOException {
        if (siteDesc == null) {
            return false;
        }
        for (VersionDesc versionDesc : siteDesc.getVersionList()) {
            if (!versionDesc.getFileName().equals(f.getName())) continue;
            return FileUtility.isMatchingSizeAndCrc(f, versionDesc.getSize(), versionDesc.getCrc()) && FileUtility.archiveHash(f) == versionDesc.getContentHash();
        }
        for (DeltaDesc deltaDesc : siteDesc.getDeltaList()) {
            if (!deltaDesc.getFileName().equals(f.getName())) continue;
            return FileUtility.isMatchingSizeAndCrc(f, deltaDesc.getSize(), deltaDesc.getCrc());
        }
        return false;
    }

    private void createDelta(String nameOld, String nameNew, String nameDelta) throws Exception {
        LogUtility.info("Create delta from " + nameOld + " to " + nameNew);
        File fOld = new File(this.m_siteDir, String.valueOf(nameOld) + ".zip");
        File fNew = new File(this.m_siteDir, String.valueOf(nameNew) + ".zip");
        File fOut = new File(this.m_siteDir, String.valueOf(nameDelta) + ".zip");
        ZipDeltaBuilder builder = new ZipDeltaBuilder(1, 0);
        builder.addRenameMapping(String.valueOf(nameOld) + "/", String.valueOf(nameNew) + "/");
        boolean equal = builder.process(fOld, fNew, fOut, this.m_tmpDir);
        if (equal) {
            throw new IllegalStateException("delta files should never be equal!");
        }
    }

    private void createF2Txt() throws Exception {
        TreeMap<Version3Q, Object> versions = new TreeMap<Version3Q, Object>();
        TreeMap<String, Object> deltas = new TreeMap<String, Object>();
        File[] fileArray = this.m_siteDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().endsWith(".zip")) {
                Object desc;
                if (this.isDeltaName(f.getName())) {
                    desc = new DeltaDesc(f.getName(), f.length(), FileUtility.crc32(f));
                    deltas.put(f.getName(), desc);
                } else {
                    desc = new VersionDesc(f.getName(), f.length(), FileUtility.crc32(f), FileUtility.archiveHash(f));
                    versions.put(((VersionDesc)desc).getVersion3Q(), desc);
                }
            }
            ++n2;
        }
        String content = new SiteDesc(versions.values(), deltas.values()).getContent();
        FileUtility.writeContent(new FileOutputStream(new File(this.m_siteDir, "f2.txt")), true, content.getBytes("UTF-8"), null);
    }

    private void testDelta(String nameOld, String nameNew, String nameDelta) throws Exception {
        LogUtility.info("TEST: verify delta " + nameDelta);
        String nameNewUpdated = "test-update-" + nameOld + "-" + nameNew;
        this.testUpdate(nameOld, nameDelta, nameNewUpdated);
        this.testCompare(nameNew, nameNewUpdated);
        new File(this.m_siteDir, String.valueOf(nameNewUpdated) + ".zip").delete();
    }

    private void testUpdate(String nameOld, String nameDelta, String nameNew) throws Exception {
        LogUtility.info("TEST: simulating update from " + nameOld + " to " + nameNew);
        File fOld = new File(this.m_siteDir, String.valueOf(nameOld) + ".zip");
        File fDelta = new File(this.m_siteDir, String.valueOf(nameDelta) + ".zip");
        File fOut = new File(this.m_siteDir, String.valueOf(nameNew) + ".zip");
        ZipDeltaUpdater builder = new ZipDeltaUpdater();
        builder.process(fOld, fDelta, fOut, this.m_tmpDir, null);
    }

    private void testCompare(String nameNew, String nameNewUpdated) throws Exception {
        LogUtility.info("TEST: comparing zip hashes");
        File f1 = new File(this.m_siteDir, String.valueOf(nameNew) + ".zip");
        File f2 = new File(this.m_siteDir, String.valueOf(nameNewUpdated) + ".zip");
        long hash1 = FileUtility.archiveHash(new FileInputStream(f1), true);
        long hash2 = FileUtility.archiveHash(new FileInputStream(f2), true);
        if (hash1 == hash2) {
            LogUtility.info("TEST: OK");
            return;
        }
        Set<String> diff = FileUtility.archiveCompare(new FileInputStream(f1), true, new FileInputStream(f2), true);
        StringBuilder buf = new StringBuilder();
        for (String s : diff) {
            buf.append(" " + s + "\n");
        }
        LogUtility.info("TEST: FAILED\n" + buf);
        throw new Exception("archives " + nameNew + " and " + nameNewUpdated + " are not equal");
    }
}

