/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal;

import org.eclipse.update.f2.internal.Version3Q;
import org.eclipse.update.f2.internal.util.PathUtility;

public class VersionDesc {
    private final String m_version;
    private final Version3Q m_v3q;
    private final String m_fileName;
    private final long m_size;
    private final long m_crc;
    private final long m_contentHash;

    public VersionDesc(String fileName, long size, long crc, long contentHash) {
        this.m_fileName = fileName;
        if (this.m_fileName.contains("$")) {
            throw new IllegalArgumentException("full version filename must not contain any '$' characters");
        }
        this.m_version = PathUtility.getPathWithoutArchiveSuffix(fileName);
        this.m_v3q = new Version3Q(this.m_version.split("_", 2)[1]);
        this.m_size = size;
        this.m_crc = crc;
        this.m_contentHash = contentHash;
    }

    public String getVersion() {
        return this.m_version;
    }

    public Version3Q getVersion3Q() {
        return this.m_v3q;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public long getSize() {
        return this.m_size;
    }

    public long getCrc() {
        return this.m_crc;
    }

    public long getContentHash() {
        return this.m_contentHash;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_version + " " + this.m_fileName + " " + this.m_size + " " + Long.toHexString(this.m_crc) + "]";
    }
}

