/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version3Q
implements Comparable<Version3Q> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)(\\.(.*))?");
    public final long major;
    public final long minor;
    public final long micro;
    public final String qualifier;

    public Version3Q(String text) {
        Matcher m;
        if (text == null) {
            text = "0.0.0";
        }
        if (!(m = VERSION_PATTERN.matcher(text)).matches()) {
            throw new IllegalArgumentException("version pattern must be like: 1.0.0.r13-201201281330");
        }
        this.major = Long.parseLong(m.group(1));
        this.minor = Long.parseLong(m.group(2));
        this.micro = Long.parseLong(m.group(3));
        this.qualifier = m.group(5);
    }

    public Version3Q(long major, long minor, long micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.micro + (this.qualifier != null ? "." + this.qualifier : "");
    }

    public int hashCode() {
        return (int)(this.major ^ this.minor ^ this.micro);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version3Q)) {
            return false;
        }
        Version3Q other = (Version3Q)obj;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && (this.qualifier == other.qualifier || this.qualifier != null && this.qualifier.equals(other.qualifier));
    }

    @Override
    public int compareTo(Version3Q other) {
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.micro > other.micro) {
            return 1;
        }
        if (this.micro < other.micro) {
            return -1;
        }
        if (this.qualifier == other.qualifier || this.qualifier != null && this.qualifier.equals(other.qualifier)) {
            return 0;
        }
        if (this.qualifier == null) {
            return -1;
        }
        if (other.qualifier == null) {
            return 1;
        }
        return this.qualifier.compareTo(other.qualifier);
    }
}

