/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.util.LogUtility;
import org.eclipse.update.f2.resource.Texts;

public class BasicUserAgent
implements IUserAgent {
    private final Map<F2Parameter, String> m_optionMap;
    private String m_progressText;
    private int m_percent;

    public BasicUserAgent(Map<F2Parameter, String> optionMap) {
        this.m_optionMap = Collections.unmodifiableMap(optionMap != null ? optionMap : new HashMap());
        this.m_progressText = Texts.Updating;
        this.m_percent = 0;
    }

    protected final Map<F2Parameter, String> getOptionMap() {
        return this.m_optionMap;
    }

    @Override
    public void preAuthenticate(AtomicReference<String> authMethod, NameCallback cbName, PasswordCallback cbPass) {
        this.authenticate(authMethod, cbName, cbPass);
    }

    @Override
    public void authenticate(AtomicReference<String> authMethod, NameCallback cbName, PasswordCallback cbPass) {
        String httpUser = this.getOptionMap().get((Object)F2Parameter.HttpUser);
        String httpPass = this.getOptionMap().get((Object)F2Parameter.HttpPass);
        if (httpUser != null) {
            cbName.setName(httpUser);
        }
        if (httpPass != null) {
            cbPass.setPassword(httpPass.toCharArray());
        }
    }

    @Override
    public void setProgressText(String name) {
        this.m_progressText = name;
        LogUtility.info(String.valueOf(this.m_progressText) + " " + this.getProgressPercent() + "%");
    }

    @Override
    public void setProgressValue(double value) {
        int newPercent = (int)(value * 100.0);
        int worked = newPercent - this.m_percent;
        if (worked > 0) {
            this.m_percent = newPercent;
            this.updateProgress(worked);
        }
    }

    protected int getProgressPercent() {
        return this.m_percent;
    }

    protected void updateProgress(int worked) {
        LogUtility.info(String.valueOf(this.m_progressText) + " " + this.getProgressPercent() + "%");
    }
}

