/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal.update;

import java.util.Map;

import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.update.linux.LinuxUpdateProcessor;
import org.eclipse.update.f2.internal.update.macosx.MacosxUpdateProcessor;
import org.eclipse.update.f2.internal.update.win32.Win32UpdateProcessor;

public final class UpdateProcessorFactory {
  private UpdateProcessorFactory() {
  }

  /**
   * @param ua
   * @param tmpRoot
   */
  public static IUpdateProcessor getProcessor(IUserAgent ua, Map<F2Parameter, String> optionMap) {
    String os = optionMap.get(F2Parameter.OS);
    if ("win32".equals(os)) {
      return new Win32UpdateProcessor(ua, optionMap);
    }
    if ("macosx".equals(os)) {
      return new MacosxUpdateProcessor(ua, optionMap);
    }
    if ("linux".equals(os)) {
      return new LinuxUpdateProcessor(ua, optionMap);
    }
    //default
    return new Win32UpdateProcessor(ua, optionMap);
  }
}
