package org.eclipse.update.f2.internal.update;

import org.eclipse.update.f2.IUserAgent;
import org.eclipse.update.f2.internal.util.IStreamingListener;

public class ProgressPhaseStreamingListener implements IStreamingListener {
  private final IUserAgent m_ua;
  private final ProgressPhase m_phase;
  private final long m_size;
  private long m_read;

  public ProgressPhaseStreamingListener(IUserAgent ua, ProgressPhase phase, long size) {
    m_ua = ua;
    m_phase = phase;
    m_size = size;
  }

  @Override
  public void streamed(long n) {
    m_read += n;
    if (m_ua != null) {
      m_ua.setProgressValue(m_phase.getProgress(m_read, m_size));
    }
  }

}
