/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.resource;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.ResourceBundle;

public class Texts {
  private static final String BUNDLE_NAME = "resources.texts.translation"; //$NON-NLS-1$

  public static String CheckForUpdate;
  public static String UnexpectedVersion;
  public static String DoUpdate;
  public static String Updating;
  public static String NothingToDo;
  public static String UpdateFailed;
  public static String UpdateRequired;
  public static String UpdateSuccessful;

  static {
    // initialize resource bundle
    ResourceBundle b = ResourceBundle.getBundle("org.eclipse.update.f2.resource.Texts", Locale.getDefault(), Texts.class.getClassLoader());
    for (Field f : Texts.class.getFields()) {
      try {
        f.set(null, b.getString(f.getName()));
      }
      catch (Throwable t) {
        t.printStackTrace();
      }
    }
  }

  private Texts() {
  }
}
