package org.eclipse.update.f2.internal.update;

public enum ProgressPhase {
    DownloadSiteDesc(0, 0.1),
    DownloadZipFiles(0.1, 0.2),
    BuildUpdate(0.3, 0.3),
    CommitCopy(0.6, 0.2),
    CommitExtract(0.8, 0.2);

  private double m_start;
  private double m_length;

  private ProgressPhase(double start, double length) {
    m_start = start;
    m_length = length;
  }

  /**
   * value/base is between 0.0 and 1.0
   * 
   * @return the progress value between 0.0 and 1.0
   */
  public double getProgress(double value, double base) {
    if (base == 0) {
      return m_start;
    }
    return m_start + m_length * Math.min(value, base) / (base + 1e-6);
  }
}
