/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the BSI AG Software License v1.0
 * which accompanies this distribution as bsi-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.update.f2.internal;

import org.eclipse.update.f2.internal.util.PathUtility;

/**
 * Descriptor for a complete version zip file named using bundle version naming (app_12.6.0.00.zip)
 */
public class VersionDesc {
  private final String m_version;
  private final Version3Q m_v3q;
  private final String m_fileName;
  private final long m_size;
  private final long m_crc;
  private final long m_contentHash;

  public VersionDesc(String fileName, long size, long crc, long contentHash) {
    m_fileName = fileName;
    if (m_fileName.contains("$")) {
      throw new IllegalArgumentException("full version filename must not contain any '$' characters");
    }
    m_version = PathUtility.getPathWithoutArchiveSuffix(fileName);
    m_v3q = new Version3Q(m_version.split("_", 2)[1]);
    m_size = size;
    m_crc = crc;
    m_contentHash = contentHash;
  }

  public String getVersion() {
    return m_version;
  }

  public Version3Q getVersion3Q() {
    return m_v3q;
  }

  public String getFileName() {
    return m_fileName;
  }

  public long getSize() {
    return m_size;
  }

  public long getCrc() {
    return m_crc;
  }

  public long getContentHash() {
    return m_contentHash;
  }

  @Override
  public String toString() {
    return getClass().getSimpleName() + "[" + m_version + " " + m_fileName + " " + m_size + " " + Long.toHexString(m_crc) + "]";
  }
}
