package org.eclipse.update.f2.ant;

import java.util.HashMap;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.update.f2.F2Parameter;
import org.eclipse.update.f2.internal.create.CreateProcessorFactory;
import org.eclipse.update.f2.internal.util.LogUtility;

public class CreateUpdateSiteTask extends Task {

  private HashMap<F2Parameter, String> m_argMap;

  public CreateUpdateSiteTask() {
    m_argMap = new HashMap<F2Parameter, String>();
  }

  public void setWindowsUAC(Boolean windowsUAC) {
    m_argMap.put(F2Parameter.WindowsUAC, windowsUAC == null ? null : Boolean.toString(windowsUAC));
  }

  public Boolean getWindowsUAC() {
    return Boolean.parseBoolean(m_argMap.get(F2Parameter.WindowsUAC));
  }

  public void setOS(String os) {
    m_argMap.put(F2Parameter.OS, os);
  }

  public String getOS() {
    return m_argMap.get(F2Parameter.OS);
  }

  public void setArch(String arch) {
    m_argMap.put(F2Parameter.Arch, arch);
  }

  public String getArch() {
    return m_argMap.get(F2Parameter.Arch);
  }

  public void setSite(String site) {
    m_argMap.put(F2Parameter.SiteDirectory, site);
  }

  public String getSite() {
    return m_argMap.get(F2Parameter.SiteDirectory);
  }

  public void setName(String name) {
    m_argMap.put(F2Parameter.Name, name);
  }

  public String getName() {
    return m_argMap.get(F2Parameter.Name);
  }

  public void setTemp(String temp) {
    m_argMap.put(F2Parameter.TempDirectory, temp);
  }

  public String getTemp() {
    return m_argMap.get(F2Parameter.TempDirectory);
  }

  public void setVersionsToKeep(String versionsToKeep) {
    m_argMap.put(F2Parameter.NumberOfVersionsToKeep, versionsToKeep);
  }

  public String getVersionsToKeep() {
    return m_argMap.get(F2Parameter.NumberOfVersionsToKeep);
  }

  @Override
  public void execute() throws BuildException {
    try {
      LogUtility.setVerbose();
      CreateProcessorFactory.getProcessor(m_argMap).create();
    }
    catch (BuildException e) {
      e.printStackTrace();
      throw e;
    }
    catch (Throwable t) {
      t.printStackTrace();
      throw new BuildException("Unexpected failure, see error log for more details: " + t, t);
    }
  }
}
