/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.f2.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogUtility {
    private static final Logger LOG = Logger.getLogger("org.eclipse.update.f2");

    private LogUtility() {
    }

    public static void setVerbose() {
        LOG.setLevel(Level.ALL);
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            if (h.getFormatter() instanceof SimpleFormatter) {
                h.setFormatter(new SingleLineFormatter());
            }
            ++n2;
        }
    }

    public static void setSilent() {
        LOG.setLevel(Level.SEVERE);
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            if (h.getFormatter() instanceof SimpleFormatter) {
                h.setFormatter(new SingleLineFormatter());
            }
            ++n2;
        }
    }

    public static void info(String s) {
        LOG.log(Level.INFO, s);
    }

    public static void warn(String s, Throwable t) {
        if (t == null) {
            LOG.log(Level.WARNING, s);
        } else {
            LOG.log(Level.WARNING, s, t);
        }
    }

    public static void error(String s, Throwable t) {
        if (t == null) {
            LOG.log(Level.SEVERE, s);
        } else {
            LOG.log(Level.SEVERE, s, t);
        }
    }

    private static class SingleLineFormatter
    extends Formatter {
        private SingleLineFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            sb.append(this.formatMessage(record));
            if (record.getThrown() != null) {
                sb.append("\n");
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sb.append("\n");
            return sb.toString();
        }
    }
}

